/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Copyright  2009 ParaType Ltd. All rights reserved.
 * 
 * Trademark:
 * PT Sans is a trademark of the ParaType Ltd.
 * 
 * Description:
 * PT Sans is a type family of universal use. It consists of 8 styles: regular and
 * bold weights with corresponding italics form a standard computer font family;
 * two narrow styles (regular and bold) are intended for documents that require
 * tight set; two caption styles (regular and bold) are for texts of small point
 * sizes. The design combines traditional conservative appearance with modern
 * trends of humanistic sans serif and characterized by enhanced legibility. These
 * features beside conventional use in business applications and printed stuff made
 * the fonts quite useable for direction and guide signs, schemes, screens of
 * information kiosks and other objects of urban visual communications.
 * 
 * The fonts next to standard Latin and Cyrillic character sets contain signs of
 * title languages of the national republics of Russian Federation and support the
 * most of the languages of neighboring countries. The fonts were developed and
 * released by ParaType in 2009 with financial support from Federal Agency of Print
 * and Mass Communications of Russian Federation. Design - Alexandra Korolkova with
 * assistance of Olga Umpeleva and supervision of Vladimir Yefimov.
 * 
 * Manufacturer:
 * ParaType Ltd
 * 
 * Designer:
 * A.Korolkova, O.Umpeleva, V.Yefimov
 * 
 * Vendor URL:
 * http://www.paratype.com
 */
Cufon.registerFont({"w":218,"face":{"font-family":"PT Sans Bold","font-weight":700,"font-stretch":"normal","units-per-em":"360","panose-1":"2 11 7 3 2 2 3 2 2 4","ascent":"288","descent":"-72","x-height":"5","bbox":"-18 -313 355 83.9124","underline-thickness":"18","underline-position":"-18","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":91,"k":{"*":13,"-":16,"\u00ad":16,"\u2013":16,"\u2014":16,",":25,".":25,"\u2026":25,"A":14,"\u00c0":14,"\u00c1":14,"\u00c2":14,"\u00c3":14,"\u00c4":14,"\u00c5":14,"C":5,"G":5,"O":5,"Q":5,"\u00c7":5,"\u00d2":5,"\u00d3":5,"\u00d4":5,"\u00d5":5,"\u00d6":5,"\u00d8":5,"T":13,"V":11,"W":9,"X":11,"Y":11,"\u00dd":11,"Z":4,"v":7,"y":7,"\u00fd":7,"\u00ff":7,"w":5,"x":6,"\u00c6":8,"\"":30,"'":30,"\u2018":30,"\u2019":30,"\u201c":30,"\u201d":30}},"!":{"d":"36,-252r48,0v0,62,3,127,-9,177r-30,0v-11,-51,-9,-115,-9,-177xm60,4v-17,0,-29,-12,-29,-28v0,-16,11,-27,29,-27v18,0,29,11,29,27v0,16,-12,28,-29,28","w":105},"\"":{"d":"32,-252r41,0r-13,78r-28,0r0,-78xm85,-252r41,0r-13,78r-28,0r0,-78","w":144,"k":{" ":33,"\u00a0":33,"-":72,"\u00ad":72,"\u2013":72,"\u2014":72,",":47,".":47,"\u2026":47,"A":46,"\u00c0":46,"\u00c1":46,"\u00c2":46,"\u00c3":46,"\u00c4":46,"\u00c5":46,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"T":-7,"V":-14,"W":-14,"Y":-13,"\u00dd":-13,"Z":-7,"c":37,"e":37,"g":37,"o":37,"q":37,"\u00e7":37,"\u00e8":37,"\u00e9":37,"\u00ea":37,"\u00eb":37,"\u00f0":37,"\u00f2":37,"\u00f3":37,"\u00f4":37,"\u00f5":37,"\u00f6":37,"\u00f8":37,"t":4,"z":5,"\u00c6":72,"a":26,"m":26,"n":26,"p":26,"r":26,"s":26,"u":26,"\u00e6":26}},"#":{"d":"111,-74r-32,0r-13,56r-38,0r13,-56r-27,0r8,-35r27,0r9,-38r-26,0r8,-35r26,0r13,-52r38,0r-12,52r32,0r12,-52r39,0r-13,52r26,0r-9,35r-25,0r-9,38r25,0r-9,35r-24,0r-13,56r-39,0xm87,-109r33,0r9,-38r-33,0"},"$":{"d":"193,-73v0,45,-25,68,-63,76r0,33r-37,0r0,-31v-24,-1,-45,-6,-60,-13r14,-41v10,7,28,11,46,13r0,-74v-30,-14,-61,-30,-61,-75v0,-43,25,-63,61,-70r0,-33r37,0r0,31v20,2,35,6,50,12r-13,40v-9,-5,-23,-9,-37,-10r0,67v30,15,62,31,63,75xm115,-36v28,1,41,-34,22,-51v-6,-5,-13,-9,-22,-13r0,64xm108,-216v-28,-3,-37,29,-21,45v6,5,13,9,21,13r0,-58"},"%":{"d":"244,-257r26,24r-207,238r-27,-25xm81,-134v-41,0,-63,-20,-63,-61v1,-40,22,-61,63,-61v41,0,63,19,63,61v0,42,-22,61,-63,61xm81,-226v-17,0,-21,11,-21,31v0,21,7,31,21,31v17,0,21,-10,21,-31v0,-20,-4,-31,-21,-31xm227,0v-41,0,-63,-20,-63,-61v1,-40,22,-61,63,-61v41,0,63,19,63,61v0,42,-22,61,-63,61xm227,-92v-17,0,-21,11,-21,31v0,21,7,31,21,31v17,0,21,-10,21,-31v0,-20,-4,-31,-21,-31","w":302},"&":{"d":"203,-25v-41,47,-175,41,-170,-45v3,-45,30,-68,61,-86v-35,-33,-24,-106,41,-101v35,3,61,12,61,46v0,30,-20,47,-46,62v17,26,32,45,53,67v12,-12,20,-33,27,-50r34,18v-7,20,-20,41,-32,57v13,13,22,20,38,27r-25,35v-16,-7,-30,-18,-42,-30xm80,-74v-4,46,74,49,95,20v-22,-22,-44,-48,-60,-73v-19,15,-33,26,-35,53xm139,-222v-28,0,-21,33,-6,51v13,-10,25,-16,26,-32v1,-14,-6,-19,-20,-19","w":293},"'":{"d":"32,-252r41,0r-13,78r-28,0r0,-78","w":91,"k":{" ":33,"\u00a0":33,"-":72,"\u00ad":72,"\u2013":72,"\u2014":72,",":47,".":47,"\u2026":47,"A":46,"\u00c0":46,"\u00c1":46,"\u00c2":46,"\u00c3":46,"\u00c4":46,"\u00c5":46,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"T":-7,"V":-14,"W":-14,"Y":-13,"\u00dd":-13,"Z":-7,"c":37,"e":37,"g":37,"o":37,"q":37,"\u00e7":37,"\u00e8":37,"\u00e9":37,"\u00ea":37,"\u00eb":37,"\u00f0":37,"\u00f2":37,"\u00f3":37,"\u00f4":37,"\u00f5":37,"\u00f6":37,"\u00f8":37,"t":4,"z":5,"\u00c6":72,"a":26,"m":26,"n":26,"p":26,"r":26,"s":26,"u":26,"\u00e6":26}},"(":{"d":"113,-237v-58,67,-59,230,1,296r-32,20v-79,-68,-77,-269,1,-335","w":117,"k":{"-":13,"\u00ad":13,"\u2013":13,"\u2014":13,",":11,".":11,"\u2026":11,"A":6,"\u00c0":6,"\u00c1":6,"\u00c2":6,"\u00c3":6,"\u00c4":6,"\u00c5":6,"C":6,"G":6,"O":6,"Q":6,"\u00c7":6,"\u00d2":6,"\u00d3":6,"\u00d4":6,"\u00d5":6,"\u00d6":6,"\u00d8":6,"c":6,"e":6,"g":6,"o":6,"q":6,"\u00e7":6,"\u00e8":6,"\u00e9":6,"\u00ea":6,"\u00eb":6,"\u00f0":6,"\u00f2":6,"\u00f3":6,"\u00f4":6,"\u00f5":6,"\u00f6":6,"\u00f8":6,"t":4}},")":{"d":"4,59v60,-66,57,-228,0,-295r32,-20v64,58,80,212,27,296v-8,14,-17,27,-28,39","w":117},"*":{"d":"52,-263v8,10,13,23,15,38v4,-14,9,-27,16,-38r23,13v-7,14,-16,25,-28,34v13,-4,26,-7,44,-6r0,27v-17,1,-30,-2,-42,-6v10,9,21,19,27,32r-23,13v-8,-11,-13,-24,-17,-39v-3,15,-8,27,-15,38r-23,-13v6,-13,15,-23,26,-31v-11,4,-24,7,-41,6r0,-27v17,-1,31,2,43,6v-11,-9,-22,-19,-28,-34","w":136,"k":{" ":13,"\u00a0":13,"-":69,"\u00ad":69,"\u2013":69,"\u2014":69,",":90,".":90,"\u2026":90,"A":20,"\u00c0":20,"\u00c1":20,"\u00c2":20,"\u00c3":20,"\u00c4":20,"\u00c5":20,"C":4,"G":4,"O":4,"Q":4,"\u00c7":4,"\u00d2":4,"\u00d3":4,"\u00d4":4,"\u00d5":4,"\u00d6":4,"\u00d8":4,"T":-6,"V":-4,"W":-5,"Y":-4,"\u00dd":-4,"Z":-7,"c":7,"e":7,"g":7,"o":7,"q":7,"\u00e7":7,"\u00e8":7,"\u00e9":7,"\u00ea":7,"\u00eb":7,"\u00f0":7,"\u00f2":7,"\u00f3":7,"\u00f4":7,"\u00f5":7,"\u00f6":7,"\u00f8":7,"v":-8,"y":-8,"\u00fd":-8,"\u00ff":-8,"\u00c6":45}},"+":{"d":"15,-142r59,0r0,-61r42,0r0,61r59,0r0,40r-59,0r0,62r-42,0r0,-62r-59,0r0,-40","w":189},",":{"d":"43,-50v42,-2,39,66,15,84v-8,9,-19,16,-31,19r-14,-19v11,-5,25,-17,25,-32v-13,2,-24,-9,-23,-25v1,-16,12,-27,28,-27","w":82,"k":{" ":14,"\u00a0":14,"*":48,"-":42,"\u00ad":42,"\u2013":42,"\u2014":42,",":-5,".":-5,"\u2026":-5,"A":-20,"\u00c0":-20,"\u00c1":-20,"\u00c2":-20,"\u00c3":-20,"\u00c4":-20,"\u00c5":-20,"T":20,"V":22,"W":14,"X":-7,"Y":25,"\u00dd":25,"Z":-14,"t":4,"v":8,"y":8,"\u00fd":8,"\u00ff":8,"w":5,"z":-7,"\"":50,"'":50,"\u2018":50,"\u2019":50,"\u201c":50,"\u201d":50,"\u00ae":32,"\u2122":32,"a":-7,"m":-7,"n":-7,"p":-7,"r":-7,"s":-7,"u":-7,"\u00e6":-7,"\u00e0":-7,"\u00e1":-7,"\u00e2":-7,"\u00e3":-7,"\u00e4":-7,"\u00e5":-7,"\u00ec":-7,"\u00ed":-7,"\u00ee":-7,"\u00ef":-7,"\u00f1":-7,"\u00f9":-7,"\u00fa":-7,"\u00fb":-7,"\u00fc":-7}},"-":{"d":"19,-124r91,0r0,41r-91,0r0,-41","w":129,"k":{" ":29,"\u00a0":29,")":13,"]":13,"}":13,"*":15,"-":21,"\u00ad":21,"\u2013":21,"\u2014":21,",":42,".":42,"\u2026":42,"A":8,"\u00c0":8,"\u00c1":8,"\u00c2":8,"\u00c3":8,"\u00c4":8,"\u00c5":8,"T":25,"V":11,"W":7,"X":16,"Y":15,"\u00dd":15,"Z":4,"x":6,"\u00c6":15,"\"":67,"'":67,"\u2018":67,"\u2019":67,"\u201c":67,"\u201d":67}},".":{"d":"44,4v-17,0,-29,-12,-29,-28v0,-16,11,-27,29,-27v18,0,29,10,29,27v0,17,-12,28,-29,28","w":88,"k":{" ":14,"\u00a0":14,"*":48,"-":42,"\u00ad":42,"\u2013":42,"\u2014":42,",":-5,".":-5,"\u2026":-5,"A":-20,"\u00c0":-20,"\u00c1":-20,"\u00c2":-20,"\u00c3":-20,"\u00c4":-20,"\u00c5":-20,"T":20,"V":22,"W":14,"X":-7,"Y":25,"\u00dd":25,"Z":-14,"t":4,"v":8,"y":8,"\u00fd":8,"\u00ff":8,"w":5,"z":-7,"\"":50,"'":50,"\u2018":50,"\u2019":50,"\u201c":50,"\u201d":50,"\u00ae":32,"\u2122":32,"a":-7,"m":-7,"n":-7,"p":-7,"r":-7,"s":-7,"u":-7,"\u00e6":-7,"\u00e0":-7,"\u00e1":-7,"\u00e2":-7,"\u00e3":-7,"\u00e4":-7,"\u00e5":-7,"\u00ec":-7,"\u00ed":-7,"\u00ee":-7,"\u00ef":-7,"\u00f1":-7,"\u00f9":-7,"\u00fa":-7,"\u00fb":-7,"\u00fc":-7}},"\/":{"d":"120,-256r35,16r-128,290r-36,-16","w":146},"0":{"d":"109,5v-67,0,-87,-57,-87,-131v-1,-77,21,-131,87,-131v70,0,88,52,88,131v0,76,-22,131,-88,131xm109,-217v-38,0,-41,43,-41,91v0,46,3,91,41,91v37,0,41,-41,41,-91v-1,-47,-3,-91,-41,-91"},"1":{"d":"44,-40r50,0v2,-55,-5,-119,5,-166v-12,19,-30,31,-49,43r-20,-27r82,-66r26,0r0,216r49,0r0,40r-143,0r0,-40"},"2":{"d":"33,-231v38,-39,151,-38,145,41v-5,63,-41,101,-70,139v-5,7,-14,9,-19,16v26,-8,62,-4,95,-5r0,40r-152,0r0,-24v36,-44,91,-85,99,-158v5,-44,-60,-38,-79,-16"},"3":{"d":"48,-45v29,18,92,14,92,-30v0,-39,-35,-41,-77,-40r0,-25v21,-26,37,-56,64,-76v-26,5,-58,4,-89,4r0,-40r138,0r0,26r-51,68v-5,4,-13,5,-16,11v46,-7,77,22,77,69v0,79,-84,98,-151,72"},"4":{"d":"206,-70r-39,0r0,70r-44,0r0,-70r-109,0r0,-27r114,-157r39,0r0,146r39,0r0,38xm123,-108r2,-85v-16,36,-38,66,-68,88v19,-4,43,-3,66,-3"},"5":{"d":"44,-44v34,16,91,10,91,-36v0,-41,-44,-43,-85,-40r0,-132r124,0r0,44r-84,0r0,49v54,-7,92,23,92,78v0,78,-81,102,-150,76"},"6":{"d":"73,-134v38,-44,128,-15,121,56v-5,51,-30,81,-82,83v-108,5,-100,-154,-48,-210v23,-25,51,-46,90,-52r10,37v-48,9,-79,41,-91,86xm111,-35v23,1,38,-19,38,-41v0,-49,-65,-50,-78,-18v-2,34,9,58,40,59"},"7":{"d":"45,0r82,-194r16,-18v-32,7,-76,3,-114,4r0,-44r162,0r0,14r-101,238r-45,0","k":{" ":19,"\u00a0":19,"-":23,"\u00ad":23,"\u2013":23,"\u2014":23,",":43,".":43,"\u2026":43,"A":24,"\u00c0":24,"\u00c1":24,"\u00c2":24,"\u00c3":24,"\u00c4":24,"\u00c5":24,"C":11,"G":11,"O":11,"Q":11,"\u00c7":11,"\u00d2":11,"\u00d3":11,"\u00d4":11,"\u00d5":11,"\u00d6":11,"\u00d8":11,"X":11,"Y":4,"\u00dd":4,"c":20,"e":20,"g":20,"o":20,"q":20,"\u00e7":20,"\u00e8":20,"\u00e9":20,"\u00ea":20,"\u00eb":20,"\u00f0":20,"\u00f2":20,"\u00f3":20,"\u00f4":20,"\u00f5":20,"\u00f6":20,"\u00f8":20,"t":12,"v":14,"y":14,"\u00fd":14,"\u00ff":14,"w":14,"x":19,"z":20,"\u00c6":33,"a":20,"m":20,"n":20,"p":20,"r":20,"s":20,"u":20,"\u00e6":20,"\u00e0":7,"\u00e1":7,"\u00e2":7,"\u00e3":7,"\u00e4":7,"\u00e5":7,"\u00ec":7,"\u00ed":7,"\u00ee":7,"\u00ef":7,"\u00f1":7,"\u00f9":7,"\u00fa":7,"\u00fb":7,"\u00fc":7}},"8":{"d":"108,5v-46,0,-79,-22,-79,-67v0,-36,22,-52,44,-67v-21,-13,-38,-30,-38,-61v0,-44,31,-67,76,-67v44,0,73,21,73,61v0,32,-16,48,-38,63v25,16,44,29,44,66v0,48,-34,72,-82,72xm109,-35v37,0,46,-39,22,-59v-9,-7,-20,-13,-30,-19v-37,12,-40,78,8,78xm111,-217v-33,-2,-40,38,-19,54v7,6,17,12,27,16v29,-18,31,-67,-8,-70"},"9":{"d":"144,-112v-43,39,-126,4,-121,-61v4,-52,30,-81,83,-84v111,-7,101,162,48,218v-22,24,-52,40,-90,44r-10,-37v50,-6,80,-34,90,-80xm106,-219v-25,-1,-37,18,-37,43v0,27,16,42,40,42v22,0,42,-6,40,-31v-2,-30,-13,-53,-43,-54"},":":{"d":"62,-126v-17,0,-29,-12,-29,-28v0,-16,11,-27,29,-27v18,0,29,10,29,27v0,17,-12,28,-29,28xm62,4v-17,0,-29,-12,-29,-28v0,-16,11,-27,29,-27v18,0,29,10,29,27v0,17,-12,28,-29,28","w":106},";":{"d":"57,-50v42,-2,39,66,15,84v-8,9,-19,16,-31,19r-14,-19v11,-5,25,-17,25,-32v-13,2,-24,-9,-23,-25v1,-16,12,-27,28,-27xm58,-126v-17,0,-29,-12,-29,-28v0,-16,11,-27,29,-27v18,0,29,10,29,27v0,17,-12,28,-29,28","w":104},"<":{"d":"14,-103r0,-25r139,-83r21,32v-37,22,-70,48,-114,63v46,13,78,40,116,61r-21,32","w":189},"=":{"d":"15,-108r160,0r0,41r-160,0r0,-41xm15,-176r160,0r0,40r-160,0r0,-40","w":189},">":{"d":"175,-131r0,25r-139,83r-20,-33v37,-21,69,-47,113,-62v-46,-13,-77,-40,-115,-61r21,-32","w":189},"?":{"d":"155,-197v0,67,-64,61,-66,122r-40,0v-6,-54,32,-68,53,-98v21,-30,-16,-55,-53,-40r-23,12r-18,-34v39,-33,147,-34,147,38xm71,4v-17,0,-29,-12,-29,-28v0,-16,11,-27,29,-27v18,0,29,11,29,27v0,16,-12,28,-29,28","w":163},"@":{"d":"67,-86v-5,97,90,142,176,110r11,35v-112,41,-234,-21,-228,-144v5,-106,68,-171,173,-171v93,0,156,47,156,139v0,65,-41,105,-104,110v-28,1,-41,-14,-40,-40v-15,19,-29,40,-62,40v-29,0,-43,-22,-43,-53v0,-61,32,-110,90,-116v17,-1,28,6,37,13v6,-10,19,-13,37,-11v-5,40,-20,80,-18,122v2,5,6,7,12,7v37,-2,51,-34,51,-72v0,-71,-46,-102,-116,-102v-81,0,-128,52,-132,133xm150,-72v0,39,44,27,54,5v13,-14,13,-42,18,-64v-37,-25,-72,17,-72,59","w":381},"A":{"d":"146,-56r-78,0r-19,56r-49,0r91,-254r36,0r91,254r-52,0xm81,-95r54,0v-12,-29,-18,-65,-28,-96v-6,35,-16,65,-26,96","w":217},"B":{"d":"22,-250v68,-8,167,-19,169,57v1,35,-22,48,-45,60v32,5,53,24,53,62v0,81,-101,81,-177,69r0,-248xm148,-73v0,-38,-40,-37,-79,-36r0,70v37,4,78,3,79,-34xm141,-183v2,-35,-41,-34,-72,-30r0,67v35,0,70,-5,72,-37","w":212,"k":{"T":11}},"C":{"d":"66,-126v-10,71,63,107,116,75r10,41v-15,11,-42,15,-66,15v-77,0,-109,-50,-112,-131v-4,-104,79,-153,175,-121r-10,41v-61,-22,-121,7,-113,80","w":201,"k":{" ":14,"\u00a0":14,"-":25,"\u00ad":25,"\u2013":25,"\u2014":25,"A":16,"\u00c0":16,"\u00c1":16,"\u00c2":16,"\u00c3":16,"\u00c4":16,"\u00c5":16,"C":12,"G":12,"O":12,"Q":12,"\u00c7":12,"\u00d2":12,"\u00d3":12,"\u00d4":12,"\u00d5":12,"\u00d6":12,"\u00d8":12,"T":16,"V":24,"W":9,"X":18,"Y":20,"\u00dd":20,"Z":18,"c":13,"e":13,"g":13,"o":13,"q":13,"\u00e7":13,"\u00e8":13,"\u00e9":13,"\u00ea":13,"\u00eb":13,"\u00f0":13,"\u00f2":13,"\u00f3":13,"\u00f4":13,"\u00f5":13,"\u00f6":13,"\u00f8":13,"t":13,"v":19,"y":19,"\u00fd":19,"\u00ff":19,"w":14,"x":16,"z":6,"\u00c6":44,"a":4,"m":4,"n":4,"p":4,"r":4,"s":4,"u":4,"\u00e6":4}},"D":{"d":"219,-128v0,110,-84,147,-197,128r0,-252v21,-4,50,-4,73,-4v83,0,124,45,124,128xm167,-128v0,-61,-32,-93,-96,-82r0,169v66,9,96,-25,96,-87","w":232,"k":{"J":8," ":5,"\u00a0":5,")":6,"]":6,"}":6,"*":4,",":11,".":11,"\u2026":11,"A":10,"\u00c0":10,"\u00c1":10,"\u00c2":10,"\u00c3":10,"\u00c4":10,"\u00c5":10,"T":14,"V":13,"W":10,"X":20,"Y":17,"\u00dd":17,"Z":9,"v":3,"y":3,"\u00fd":3,"\u00ff":3,"x":11,"z":6,"\u00c6":22,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14}},"E":{"d":"22,-252r149,0r0,44r-100,0r0,59r91,0r0,44r-91,0r0,61r102,0r0,44r-151,0r0,-252","w":187},"F":{"d":"22,-252r149,0r0,44r-100,0r0,62r92,0r0,44r-92,0r0,102r-49,0r0,-252","w":182},"G":{"d":"66,-126v-5,64,45,106,99,78r0,-48r-54,-6r0,-29r93,0r0,112v-18,15,-47,24,-77,24v-77,0,-113,-50,-113,-131v0,-105,83,-153,181,-121r-10,41v-62,-21,-128,6,-119,80","w":219},"H":{"d":"163,-105r-92,0r0,105r-49,0r0,-252r49,0r0,103r92,0r0,-103r49,0r0,252r-49,0r0,-105","w":234},"I":{"d":"27,-252r49,0r0,252r-49,0r0,-252","w":102},"J":{"d":"3,-44v26,12,44,-2,44,-36r0,-172r49,0r0,184v6,61,-50,86,-104,64","w":120},"K":{"d":"84,-108r-13,0r0,108r-49,0r0,-252r49,0r0,112r11,-5r70,-107r56,0r-73,106r-20,14r20,14r84,118r-61,0","w":223,"k":{" ":11,"\u00a0":11,"-":29,"\u00ad":29,"\u2013":29,"\u2014":29,"A":11,"\u00c0":11,"\u00c1":11,"\u00c2":11,"\u00c3":11,"\u00c4":11,"\u00c5":11,"C":20,"G":20,"O":20,"Q":20,"\u00c7":20,"\u00d2":20,"\u00d3":20,"\u00d4":20,"\u00d5":20,"\u00d6":20,"\u00d8":20,"T":17,"V":13,"W":11,"X":13,"Y":15,"\u00dd":15,"Z":5,"c":17,"e":17,"g":17,"o":17,"q":17,"\u00e7":17,"\u00e8":17,"\u00e9":17,"\u00ea":17,"\u00eb":17,"\u00f0":17,"\u00f2":17,"\u00f3":17,"\u00f4":17,"\u00f5":17,"\u00f6":17,"\u00f8":17,"t":17,"v":19,"y":19,"\u00fd":19,"\u00ff":19,"w":19,"x":18,"z":6,"\u00c6":45,"a":7,"m":7,"n":7,"p":7,"r":7,"s":7,"u":7,"\u00e6":7}},"L":{"d":"181,0r-159,0r0,-252r49,0r0,208r110,0r0,44","w":185,"k":{" ":18,"\u00a0":18,"*":59,"-":25,"\u00ad":25,"\u2013":25,"\u2014":25,",":-4,".":-4,"\u2026":-4,"A":44,"\u00c0":44,"\u00c1":44,"\u00c2":44,"\u00c3":44,"\u00c4":44,"\u00c5":44,"C":33,"G":33,"O":33,"Q":33,"\u00c7":33,"\u00d2":33,"\u00d3":33,"\u00d4":33,"\u00d5":33,"\u00d6":33,"\u00d8":33,"T":47,"V":43,"W":31,"X":51,"Y":46,"\u00dd":46,"Z":32,"c":13,"e":13,"g":13,"o":13,"q":13,"\u00e7":13,"\u00e8":13,"\u00e9":13,"\u00ea":13,"\u00eb":13,"\u00f0":13,"\u00f2":13,"\u00f3":13,"\u00f4":13,"\u00f5":13,"\u00f6":13,"\u00f8":13,"t":13,"v":31,"y":31,"\u00fd":31,"\u00ff":31,"w":22,"x":25,"z":14,"\u00c6":43,"\"":51,"'":51,"\u2018":51,"\u2019":51,"\u201c":51,"\u201d":51,"\u00ae":65,"\u2122":65,"\u00e0":-3,"\u00e1":-3,"\u00e2":-3,"\u00e3":-3,"\u00e4":-3,"\u00e5":-3,"\u00ec":-3,"\u00ed":-3,"\u00ee":-3,"\u00ef":-3,"\u00f1":-3,"\u00f9":-3,"\u00fa":-3,"\u00fb":-3,"\u00fc":-3}},"M":{"d":"217,-131v0,-16,8,-38,3,-50v-16,52,-45,91,-69,135r-16,0v-25,-44,-54,-84,-72,-135r-2,0v10,52,6,119,7,181r-46,0r0,-252r45,0v26,48,58,91,79,144v21,-52,50,-96,76,-144r44,0r0,252r-49,0r0,-131","w":288},"N":{"d":"179,2v-39,-57,-83,-109,-116,-173v9,50,4,113,5,171r-46,0r0,-254r36,0v38,58,84,107,114,173r2,0v-10,-49,-5,-113,-6,-171r47,0r0,254r-36,0","w":236},"O":{"d":"121,5v-77,0,-106,-53,-107,-131v-1,-78,33,-131,107,-131v77,0,105,54,107,131v2,78,-35,131,-107,131xm121,-213v-42,0,-56,36,-55,87v1,46,10,87,55,87v43,0,55,-36,55,-87v0,-46,-11,-87,-55,-87","w":241,"k":{"J":8," ":5,"\u00a0":5,")":6,"]":6,"}":6,"*":4,",":11,".":11,"\u2026":11,"A":10,"\u00c0":10,"\u00c1":10,"\u00c2":10,"\u00c3":10,"\u00c4":10,"\u00c5":10,"T":14,"V":13,"W":10,"X":20,"Y":17,"\u00dd":17,"Z":9,"v":3,"y":3,"\u00fd":3,"\u00ff":3,"x":11,"z":6,"\u00c6":22,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14}},"P":{"d":"197,-172v0,70,-58,94,-126,85r0,87r-49,0r0,-249v76,-15,175,-12,175,77xm145,-173v0,-38,-39,-44,-74,-38r0,81v36,6,74,-2,74,-43","w":205,"k":{" ":14,"\u00a0":14,"-":4,"\u00ad":4,"\u2013":4,"\u2014":4,",":47,".":47,"\u2026":47,"A":28,"\u00c0":28,"\u00c1":28,"\u00c2":28,"\u00c3":28,"\u00c4":28,"\u00c5":28,"C":4,"G":4,"O":4,"Q":4,"\u00c7":4,"\u00d2":4,"\u00d3":4,"\u00d4":4,"\u00d5":4,"\u00d6":4,"\u00d8":4,"T":3,"V":4,"W":3,"X":19,"Y":10,"\u00dd":10,"Z":7,"c":13,"e":13,"g":13,"o":13,"q":13,"\u00e7":13,"\u00e8":13,"\u00e9":13,"\u00ea":13,"\u00eb":13,"\u00f0":13,"\u00f2":13,"\u00f3":13,"\u00f4":13,"\u00f5":13,"\u00f6":13,"\u00f8":13,"x":13,"z":5,"\u00c6":47,"a":10,"m":10,"n":10,"p":10,"r":10,"s":10,"u":10,"\u00e6":10,"\u00e0":4,"\u00e1":4,"\u00e2":4,"\u00e3":4,"\u00e4":4,"\u00e5":4,"\u00ec":4,"\u00ed":4,"\u00ee":4,"\u00ef":4,"\u00f1":4,"\u00f9":4,"\u00fa":4,"\u00fb":4,"\u00fc":4}},"Q":{"d":"72,13v67,-10,115,34,181,17r0,43v-68,19,-116,-26,-181,-17r0,-43xm121,5v-77,0,-106,-53,-107,-131v-1,-78,33,-131,107,-131v77,0,105,54,107,131v2,78,-35,131,-107,131xm121,-213v-42,0,-56,36,-55,87v1,46,10,87,55,87v43,0,55,-36,55,-87v0,-46,-11,-87,-55,-87","w":241,"k":{"J":8," ":5,"\u00a0":5,")":6,"]":6,"}":6,"*":4,",":11,".":11,"\u2026":11,"A":10,"\u00c0":10,"\u00c1":10,"\u00c2":10,"\u00c3":10,"\u00c4":10,"\u00c5":10,"T":14,"V":13,"W":10,"X":20,"Y":17,"\u00dd":17,"Z":9,"v":3,"y":3,"\u00fd":3,"\u00ff":3,"x":11,"z":6,"\u00c6":22,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14}},"R":{"d":"189,-185v0,42,-22,68,-53,78r17,11r58,96r-57,0r-57,-99r-26,-4r0,103r-49,0r0,-249v69,-12,168,-15,167,64xm137,-177v0,-33,-33,-39,-66,-33r0,73v37,2,66,-3,66,-40","w":216,"k":{"-":14,"\u00ad":14,"\u2013":14,"\u2014":14,"A":13,"\u00c0":13,"\u00c1":13,"\u00c2":13,"\u00c3":13,"\u00c4":13,"\u00c5":13,"C":12,"G":12,"O":12,"Q":12,"\u00c7":12,"\u00d2":12,"\u00d3":12,"\u00d4":12,"\u00d5":12,"\u00d6":12,"\u00d8":12,"T":18,"V":17,"W":14,"X":20,"Y":22,"\u00dd":22,"Z":9,"c":17,"e":17,"g":17,"o":17,"q":17,"\u00e7":17,"\u00e8":17,"\u00e9":17,"\u00ea":17,"\u00eb":17,"\u00f0":17,"\u00f2":17,"\u00f3":17,"\u00f4":17,"\u00f5":17,"\u00f6":17,"\u00f8":17,"t":9,"v":8,"y":8,"\u00fd":8,"\u00ff":8,"w":8,"x":10,"z":5,"\u00c6":47,"\"":7,"'":7,"\u2018":7,"\u2019":7,"\u201c":7,"\u201d":7}},"S":{"d":"26,-52v26,14,103,30,104,-16v-18,-57,-115,-34,-115,-117v0,-78,101,-85,159,-57r-16,41v-24,-21,-121,-19,-85,30v37,29,104,32,107,98v4,85,-107,91,-170,63","w":190},"T":{"d":"201,-208r-74,0r0,208r-49,0r0,-208r-74,0r0,-44r197,0r0,44","w":204,"k":{"\u00ff":46,"\u00fd":46,"\u00fc":24,"\u00f6":46,"\u00f5":46,"\u00f4":46,"\u00f3":46,"\u00f2":46,"\u00ef":24,"\u00ee":24,"\u00ed":24,"\u00ec":24,"\u00eb":46,"\u00ea":46,"\u00e9":46,"\u00e8":46,"\u00e5":24,"\u00e4":24,"\u00e3":24,"\u00e1":24," ":14,"\u00a0":14,")":-5,"]":-5,"}":-5,"*":-6,"-":46,"\u00ad":46,"\u2013":46,"\u2014":46,",":40,".":40,"\u2026":40,"A":28,"\u00c0":28,"\u00c1":28,"\u00c2":28,"\u00c3":28,"\u00c4":28,"\u00c5":28,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"T":-7,"V":12,"W":11,"X":17,"Y":25,"\u00dd":25,"Z":18,"c":46,"e":46,"g":46,"o":46,"q":46,"\u00e7":46,"\u00f0":46,"\u00f8":46,"t":18,"v":46,"y":46,"w":46,"x":46,"z":46,"\u00c6":43,"\"":-7,"'":-7,"\u2018":-7,"\u2019":-7,"\u201c":-7,"\u201d":-7,"\u00ae":-6,"\u2122":-6,"a":38,"m":38,"n":38,"p":38,"r":38,"s":38,"u":38,"\u00e6":38,"\u00e0":24,"\u00e2":24,"\u00f1":24,"\u00f9":24,"\u00fa":24,"\u00fb":24}},"U":{"d":"116,-40v33,-1,42,-18,42,-53r0,-159r47,0r0,163v0,60,-29,93,-89,93v-64,0,-95,-29,-95,-87r0,-169r49,0r0,159v0,34,10,55,46,53","w":225},"V":{"d":"54,-252v19,64,47,118,57,191r2,0v10,-72,37,-127,55,-191r52,0r-94,254r-35,0r-94,-254r57,0","w":216,"k":{"\u00fb":14,"\u00fa":14,"\u00f6":27,"\u00f5":27,"\u00f2":27,"\u00ef":14,"\u00ee":14,"\u00ec":14,"\u00eb":27,"\u00ea":27,"\u00e8":27,"\u00e5":14,"\u00e4":14,"\u00e1":14," ":11,"\u00a0":11,"*":-14,"-":19,"\u00ad":19,"\u2013":19,"\u2014":19,",":40,".":40,"\u2026":40,"A":24,"\u00c0":24,"\u00c1":24,"\u00c2":24,"\u00c3":24,"\u00c4":24,"\u00c5":24,"C":13,"G":13,"O":13,"Q":13,"\u00c7":13,"\u00d2":13,"\u00d3":13,"\u00d4":13,"\u00d5":13,"\u00d6":13,"\u00d8":13,"T":12,"V":13,"W":11,"X":13,"Y":15,"\u00dd":15,"Z":13,"c":27,"e":27,"g":27,"o":27,"q":27,"\u00e7":27,"\u00e9":27,"\u00f0":27,"\u00f3":27,"\u00f4":27,"\u00f8":27,"t":7,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":6,"x":17,"z":17,"\u00c6":43,"\"":-14,"'":-14,"\u2018":-14,"\u2019":-14,"\u201c":-14,"\u201d":-14,"\u00ae":-5,"\u2122":-5,"a":21,"m":21,"n":21,"p":21,"r":21,"s":21,"u":21,"\u00e6":21,"\u00e0":14,"\u00e2":14,"\u00e3":14,"\u00ed":14,"\u00f1":14,"\u00f9":14,"\u00fc":14}},"W":{"d":"54,-252v13,62,32,117,38,185v8,-68,32,-124,50,-185r33,0v17,61,40,116,49,185v8,-66,24,-123,36,-185r50,0r-69,254r-33,0v-17,-60,-42,-111,-51,-179r-2,0v-9,68,-34,119,-51,179r-35,0r-69,-254r54,0","w":310,"k":{"\u00f6":19,"\u00ef":11,"\u00ee":11,"\u00ec":11,"\u00eb":19,"\u00e5":11,"\u00e2":11,"\u00e1":11," ":10,"\u00a0":10,"*":-13,"-":11,"\u00ad":11,"\u2013":11,"\u2014":11,",":31,".":31,"\u2026":31,"A":16,"\u00c0":16,"\u00c1":16,"\u00c2":16,"\u00c3":16,"\u00c4":16,"\u00c5":16,"C":10,"G":10,"O":10,"Q":10,"\u00c7":10,"\u00d2":10,"\u00d3":10,"\u00d4":10,"\u00d5":10,"\u00d6":10,"\u00d8":10,"T":11,"V":11,"W":12,"X":11,"Y":15,"\u00dd":15,"Z":12,"c":19,"e":19,"g":19,"o":19,"q":19,"\u00e7":19,"\u00e8":19,"\u00e9":19,"\u00ea":19,"\u00f0":19,"\u00f2":19,"\u00f3":19,"\u00f4":19,"\u00f5":19,"\u00f8":19,"t":5,"v":3,"y":3,"\u00fd":3,"\u00ff":3,"w":6,"x":14,"z":15,"\u00c6":35,"\"":-14,"'":-14,"\u2018":-14,"\u2019":-14,"\u201c":-14,"\u201d":-14,"\u00ae":-6,"\u2122":-6,"a":17,"m":17,"n":17,"p":17,"r":17,"s":17,"u":17,"\u00e6":17,"\u00e0":11,"\u00e3":11,"\u00e4":11,"\u00ed":11,"\u00f1":11,"\u00f9":11,"\u00fa":11,"\u00fb":11,"\u00fc":11}},"X":{"d":"81,-128r-70,-124r59,0v16,32,36,61,48,98v11,-38,33,-65,49,-98r53,0r-72,121r76,131r-59,0v-18,-35,-40,-65,-54,-104v-12,40,-36,69,-54,104r-53,0","w":227,"k":{" ":11,"\u00a0":11,"-":29,"\u00ad":29,"\u2013":29,"\u2014":29,"A":11,"\u00c0":11,"\u00c1":11,"\u00c2":11,"\u00c3":11,"\u00c4":11,"\u00c5":11,"C":20,"G":20,"O":20,"Q":20,"\u00c7":20,"\u00d2":20,"\u00d3":20,"\u00d4":20,"\u00d5":20,"\u00d6":20,"\u00d8":20,"T":17,"V":13,"W":11,"X":13,"Y":15,"\u00dd":15,"Z":5,"c":17,"e":17,"g":17,"o":17,"q":17,"\u00e7":17,"\u00e8":17,"\u00e9":17,"\u00ea":17,"\u00eb":17,"\u00f0":17,"\u00f2":17,"\u00f3":17,"\u00f4":17,"\u00f5":17,"\u00f6":17,"\u00f8":17,"t":17,"v":19,"y":19,"\u00fd":19,"\u00ff":19,"w":19,"x":18,"z":6,"\u00c6":45,"a":7,"m":7,"n":7,"p":7,"r":7,"s":7,"u":7,"\u00e6":7}},"Y":{"d":"82,-94r-83,-158r59,0v17,41,43,72,51,121r2,0v8,-49,34,-80,50,-121r53,0r-83,158r0,94r-49,0r0,-94","w":213,"k":{"\u00ff":17,"\u00fc":20,"\u00fb":20,"\u00fa":20,"\u00f6":38,"\u00f5":38,"\u00f4":38,"\u00f2":38,"\u00f1":20,"\u00ef":20,"\u00ee":20,"\u00ec":20,"\u00eb":38,"\u00ea":38,"\u00e8":38,"\u00e5":20,"\u00e4":20,"\u00e2":20,"\u00e1":20," ":10,"\u00a0":10,"*":-9,"-":24,"\u00ad":24,"\u2013":24,"\u2014":24,",":42,".":42,"\u2026":42,"A":32,"\u00c0":32,"\u00c1":32,"\u00c2":32,"\u00c3":32,"\u00c4":32,"\u00c5":32,"C":17,"G":17,"O":17,"Q":17,"\u00c7":17,"\u00d2":17,"\u00d3":17,"\u00d4":17,"\u00d5":17,"\u00d6":17,"\u00d8":17,"T":25,"V":15,"W":11,"X":15,"Y":15,"\u00dd":15,"Z":21,"c":38,"e":38,"g":38,"o":38,"q":38,"\u00e7":38,"\u00e9":38,"\u00f0":38,"\u00f3":38,"\u00f8":38,"t":18,"v":17,"y":17,"\u00fd":17,"w":14,"x":22,"z":25,"\u00c6":44,"\"":-13,"'":-13,"\u2018":-13,"\u2019":-13,"\u201c":-13,"\u201d":-13,"\u00ae":-6,"\u2122":-6,"a":26,"m":26,"n":26,"p":26,"r":26,"s":26,"u":26,"\u00e6":26,"\u00e0":20,"\u00e3":20,"\u00ed":20,"\u00f9":20}},"Z":{"d":"10,-44r106,-149r19,-15r-125,0r0,-44r174,0r0,44r-107,150r-18,14r125,0r0,44r-174,0r0,-44","w":194,"k":{" ":8,"\u00a0":8,"*":-7,"-":20,"\u00ad":20,"\u2013":20,"\u2014":20,"A":9,"\u00c0":9,"\u00c1":9,"\u00c2":9,"\u00c3":9,"\u00c4":9,"\u00c5":9,"C":9,"G":9,"O":9,"Q":9,"\u00c7":9,"\u00d2":9,"\u00d3":9,"\u00d4":9,"\u00d5":9,"\u00d6":9,"\u00d8":9,"T":9,"V":13,"W":11,"X":10,"Y":21,"\u00dd":21,"Z":4,"c":14,"e":14,"g":14,"o":14,"q":14,"\u00e7":14,"\u00e8":14,"\u00e9":14,"\u00ea":14,"\u00eb":14,"\u00f0":14,"\u00f2":14,"\u00f3":14,"\u00f4":14,"\u00f5":14,"\u00f6":14,"\u00f8":14,"t":3,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":3,"z":5,"\u00c6":46,"\"":-7,"'":-7,"\u2018":-7,"\u2019":-7,"\u201c":-7,"\u201d":-7,"a":4,"m":4,"n":4,"p":4,"r":4,"s":4,"u":4,"\u00e6":4}},"[":{"d":"22,-252r84,0r0,40r-40,0r0,255r40,0r0,40r-84,0r0,-335","w":116,"k":{"-":13,"\u00ad":13,"\u2013":13,"\u2014":13,",":11,".":11,"\u2026":11,"A":6,"\u00c0":6,"\u00c1":6,"\u00c2":6,"\u00c3":6,"\u00c4":6,"\u00c5":6,"C":6,"G":6,"O":6,"Q":6,"\u00c7":6,"\u00d2":6,"\u00d3":6,"\u00d4":6,"\u00d5":6,"\u00d6":6,"\u00d8":6,"c":6,"e":6,"g":6,"o":6,"q":6,"\u00e7":6,"\u00e8":6,"\u00e9":6,"\u00ea":6,"\u00eb":6,"\u00f0":6,"\u00f2":6,"\u00f3":6,"\u00f4":6,"\u00f5":6,"\u00f6":6,"\u00f8":6,"t":4}},"\\":{"d":"158,34r-36,16r-131,-290r37,-16","w":152},"]":{"d":"95,83r-85,0r0,-40r40,0r0,-255r-40,0r0,-40r85,0r0,335","w":116},"^":{"d":"78,-254r25,0r66,105r-47,0v-12,-22,-28,-40,-33,-69v-7,28,-23,47,-37,69r-45,0","w":180},"_":{"d":"0,42r160,0r0,39r-160,0r0,-39","w":159},"`":{"d":"92,-204r-26,0r-44,-44r0,-11r49,0","w":113},"a":{"d":"113,-107v14,-53,-55,-38,-82,-28r-12,-35v49,-20,141,-28,141,49v0,41,-8,88,4,121r-38,0v-4,-7,-3,-19,-10,-24v-20,40,-113,35,-108,-26v4,-50,50,-60,105,-57xm57,-57v0,34,49,21,56,2r0,-24v-24,-1,-56,-2,-56,22","w":178,"k":{"\u201d":15,"\u201c":15,"\u2019":15,"\u2018":15,"T":43,"'":15,"\"":15}},"b":{"d":"91,4v-25,0,-56,-5,-70,-12r0,-244r46,0v2,27,-4,63,2,86v9,-11,25,-17,45,-18v49,1,67,35,67,89v1,61,-31,99,-90,99xm67,-40v38,15,71,-6,66,-53v7,-60,-53,-66,-66,-26r0,79","w":192,"k":{"f":4,")":6,"]":6,"}":6,"*":7,",":4,".":4,"\u2026":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":3,"x":9,"z":3,"\"":27,"'":27,"\u2018":27,"\u2019":27,"\u201c":27,"\u201d":27,"\u00ae":6,"\u2122":6}},"c":{"d":"102,-36v15,0,27,-5,35,-11r11,36v-13,10,-35,16,-58,16v-57,0,-78,-38,-78,-95v0,-80,65,-115,134,-84r-11,39v-35,-19,-80,-6,-75,45v3,30,11,54,42,54","w":155,"k":{" ":9,"\u00a0":9,")":4,"]":4,"}":4,"-":14,"\u00ad":14,"\u2013":14,"\u2014":14,"c":6,"e":6,"g":6,"o":6,"q":6,"\u00e7":6,"\u00e8":6,"\u00e9":6,"\u00ea":6,"\u00eb":6,"\u00f0":6,"\u00f2":6,"\u00f3":6,"\u00f4":6,"\u00f5":6,"\u00f6":6,"\u00f8":6,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"w":6,"x":3,"z":3,"\"":8,"'":8,"\u2018":8,"\u2019":8,"\u201c":8,"\u201d":8}},"d":{"d":"12,-87v-3,-71,48,-112,115,-92r0,-73r47,0r0,219v0,10,1,21,3,33r-33,0v-3,-7,-3,-17,-8,-23v-10,16,-28,28,-53,28v-52,-1,-69,-35,-71,-92xm60,-86v3,28,8,50,34,51v47,2,30,-60,33,-102v-33,-21,-72,1,-67,51","w":194},"e":{"d":"59,-78v-6,52,62,54,90,32r16,31v-15,11,-42,20,-69,20v-59,1,-83,-36,-84,-95v0,-60,29,-94,86,-95v59,-1,81,46,69,107r-108,0xm127,-107v9,-39,-36,-52,-57,-30v-6,7,-9,18,-10,30r67,0","w":182,"k":{")":5,"]":5,"}":5,"*":8,"c":2,"e":2,"g":2,"o":2,"q":2,"\u00e7":2,"\u00e8":2,"\u00e9":2,"\u00ea":2,"\u00eb":2,"\u00f0":2,"\u00f2":2,"\u00f3":2,"\u00f4":2,"\u00f5":2,"\u00f6":2,"\u00f8":2,"v":5,"y":5,"\u00fd":5,"\u00ff":5,"w":2,"x":8,"z":2,"\"":18,"'":18,"\u2018":18,"\u2019":18,"\u201c":18,"\u201d":18,"\u00ae":8,"\u2122":8}},"f":{"d":"124,-211v-26,-9,-56,-5,-48,31r39,0r0,40r-39,0r0,140r-47,0r0,-140r-25,0r0,-40r25,0v-12,-70,49,-87,104,-68","w":115,"k":{"\u00ef":-22,"\u00ee":-9,"\u00ec":-17,"}":-22,"]":-22,")":-22,"*":-12,",":7,".":7,"\u2026":7,"c":2,"e":2,"g":2,"o":2,"q":2,"\u00e7":2,"\u00e8":2,"\u00e9":2,"\u00ea":2,"\u00eb":2,"\u00f0":2,"\u00f2":2,"\u00f3":2,"\u00f4":2,"\u00f5":2,"\u00f6":2,"\u00f8":2,"t":3,"v":5,"y":5,"\u00fd":5,"\u00ff":5,"w":4,"\"":-12,"'":-12,"\u2018":-12,"\u2019":-12,"\u201c":-12,"\u201d":-12,"\u00ae":-15,"\u2122":-15}},"g":{"d":"102,-184v27,0,52,4,71,10r0,174v8,77,-84,90,-144,65r10,-37v32,18,103,14,87,-42v-8,11,-24,17,-45,17v-51,-2,-69,-32,-69,-89v0,-62,30,-98,90,-98xm60,-88v-10,52,54,72,66,29r0,-81v-37,-15,-71,5,-66,52","w":192},"h":{"d":"122,-185v82,0,48,111,55,185r-46,0r0,-102v10,-55,-64,-51,-64,-13r0,115r-46,0r0,-252r46,0v2,29,-4,67,2,92v12,-15,26,-25,53,-25","w":196},"i":{"d":"47,-206v-17,0,-29,-9,-29,-25v0,-16,12,-25,29,-25v16,0,30,10,30,25v0,15,-14,25,-30,25xm24,-180r47,0r0,180r-47,0r0,-180","w":96},"j":{"d":"48,-206v-17,0,-30,-10,-30,-25v0,-15,13,-25,30,-25v16,0,30,10,30,25v0,15,-14,25,-30,25xm-6,33v27,2,30,-14,31,-39r0,-174r47,0r0,188v3,50,-28,77,-78,64r0,-39","w":96},"k":{"d":"80,-75r-13,0r0,75r-46,0r0,-252r46,0r0,149r11,-5r41,-72r52,0v-20,28,-33,63,-62,82r20,14r48,84r-53,0","w":176,"k":{"\u00f8":9,"\u00f6":9,"\u00f5":9,"\u00f4":9,"\u00f3":9,"\u00f2":9,"\u00f0":9,"\u00eb":9,"\u00ea":9,"\u00e9":9,"\u00e8":9,"\u00e7":9,"q":9,"o":9,"g":9,"e":9,"c":9," ":11,"\u00a0":11,"-":14,"\u00ad":14,"\u2013":14,"\u2014":14,"v":-5,"y":-5,"\u00fd":-5,"\u00ff":-5,"x":3}},"l":{"d":"106,-4v-29,14,-84,17,-84,-32r0,-216r47,0r0,192v-3,23,14,29,32,20","w":105},"m":{"d":"201,-144v-54,0,-24,94,-31,144r-47,0r0,-98v-1,-28,0,-46,-24,-46v-17,0,-26,11,-32,24r0,120r-46,0r0,-180r36,0v3,7,1,20,7,24v11,-15,28,-29,54,-29v26,0,37,11,45,31v10,-17,26,-31,53,-31v82,0,49,111,56,185r-47,0r0,-101v-1,-25,-1,-43,-24,-43","w":289},"n":{"d":"122,-185v81,0,49,111,55,185r-46,0r0,-102v8,-53,-55,-51,-64,-15r0,117r-46,0r0,-180r37,0v3,7,2,18,6,24v12,-16,30,-29,58,-29","w":196,"k":{"T":41}},"o":{"d":"97,5v-58,0,-85,-37,-85,-95v-1,-58,29,-95,85,-95v58,0,84,37,84,95v1,58,-29,95,-84,95xm97,-145v-29,0,-37,22,-37,55v0,30,8,55,37,55v28,0,36,-22,36,-55v0,-31,-8,-55,-36,-55","w":193,"k":{"f":4,")":6,"]":6,"}":6,"*":7,",":4,".":4,"\u2026":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":3,"x":9,"z":3,"\"":27,"'":27,"\u2018":27,"\u2019":27,"\u201c":27,"\u201d":27,"\u00ae":6,"\u2122":6}},"p":{"d":"183,-95v2,70,-50,118,-116,93r0,74r-46,0r0,-252r34,0v3,7,1,18,7,22v11,-17,26,-27,53,-27v52,1,66,33,68,90xm134,-96v-3,-28,-7,-48,-33,-49v-47,-2,-32,59,-34,102v34,21,73,-2,67,-53","w":194,"k":{"f":4,")":6,"]":6,"}":6,"*":7,",":4,".":4,"\u2026":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":3,"x":9,"z":3,"\"":27,"'":27,"\u2018":27,"\u2019":27,"\u201c":27,"\u201d":27,"\u00ae":6,"\u2122":6}},"q":{"d":"12,-86v0,-91,85,-114,161,-88r0,246r-47,0r-1,-87v-9,12,-23,20,-44,20v-49,-2,-69,-36,-69,-91xm60,-88v-10,52,54,72,66,29r0,-81v-37,-17,-70,8,-66,52","w":192},"r":{"d":"64,-156v8,-23,34,-35,62,-24r-6,44v-23,-10,-48,0,-53,20r0,116r-46,0r0,-180r36,0v3,7,1,20,7,24","w":126,"k":{",":11,".":11,"\u2026":11,"t":-11}},"s":{"d":"22,-46v17,15,92,24,67,-15v-29,-18,-76,-20,-76,-69v0,-63,83,-64,125,-41r-11,34v-17,-12,-86,-18,-61,16v29,17,76,19,76,67v0,65,-89,70,-133,43","w":151},"t":{"d":"124,-6v-38,19,-97,18,-97,-44r0,-90r-25,0r0,-40r25,0r0,-34r46,-13r0,47r44,0r0,40r-44,0v2,43,-16,127,43,98","w":125,"k":{")":4,"]":4,"}":4,"-":6,"\u00ad":6,"\u2013":6,"\u2014":6,",":-4,".":-4,"\u2026":-4,"c":2,"e":2,"g":2,"o":2,"q":2,"\u00e7":2,"\u00e8":2,"\u00e9":2,"\u00ea":2,"\u00eb":2,"\u00f0":2,"\u00f2":2,"\u00f3":2,"\u00f4":2,"\u00f5":2,"\u00f6":2,"\u00f8":2,"t":3,"v":8,"y":8,"\u00fd":8,"\u00ff":8,"w":6,"x":3,"\"":4,"'":4,"\u2018":4,"\u2019":4,"\u201c":4,"\u201d":4}},"u":{"d":"76,5v-83,0,-51,-110,-57,-185r47,0r0,102v-10,55,60,50,60,14r0,-116r47,0v1,61,-5,129,6,180r-35,0v-4,-9,-5,-20,-10,-27v-11,17,-31,32,-58,32","w":193},"v":{"d":"49,-180v13,41,31,77,40,122r2,0v7,-45,23,-81,35,-122r51,0r-75,182r-29,0r-78,-182r54,0","w":171,"k":{" ":13,"\u00a0":13,"*":-8,",":26,".":26,"\u2026":26,"c":3,"e":3,"g":3,"o":3,"q":3,"\u00e7":3,"\u00e8":3,"\u00e9":3,"\u00ea":3,"\u00eb":3,"\u00f0":3,"\u00f2":3,"\u00f3":3,"\u00f4":3,"\u00f5":3,"\u00f6":3,"\u00f8":3,"t":6,"v":-15,"y":-15,"\u00fd":-15,"\u00ff":-15,"w":-12,"x":-3}},"w":{"d":"151,-180v13,41,31,76,39,122r2,0v6,-44,19,-81,28,-122r42,0r-55,182r-35,0r-42,-124v-9,45,-26,82,-39,124r-36,0r-58,-182r51,0v12,39,22,80,32,122v7,-46,24,-82,36,-122r35,0","w":259,"k":{" ":9,"\u00a0":9,",":20,".":20,"\u2026":20,"c":3,"e":3,"g":3,"o":3,"q":3,"\u00e7":3,"\u00e8":3,"\u00e9":3,"\u00ea":3,"\u00eb":3,"\u00f0":3,"\u00f2":3,"\u00f3":3,"\u00f4":3,"\u00f5":3,"\u00f6":3,"\u00f8":3,"t":4,"v":-12,"y":-12,"\u00fd":-12,"\u00ff":-12,"w":-8,"z":3}},"x":{"d":"61,-92r-54,-88r56,0v12,20,25,40,33,64v9,-24,23,-44,36,-64r51,0r-55,86r58,94r-54,0v-14,-22,-30,-43,-39,-70v-9,27,-25,48,-39,70r-51,0","w":189,"k":{" ":11,"\u00a0":11,"-":14,"\u00ad":14,"\u2013":14,"\u2014":14,"c":9,"e":9,"g":9,"o":9,"q":9,"\u00e7":9,"\u00e8":9,"\u00e9":9,"\u00ea":9,"\u00eb":9,"\u00f0":9,"\u00f2":9,"\u00f3":9,"\u00f4":9,"\u00f5":9,"\u00f6":9,"\u00f8":9,"v":-5,"y":-5,"\u00fd":-5,"\u00ff":-5,"x":3}},"y":{"d":"53,-180v15,42,24,90,42,129v6,-48,21,-86,32,-129r48,0r-68,199v-10,35,-39,69,-82,49r8,-38v23,7,34,-9,39,-30r-75,-180r56,0","w":172,"k":{" ":13,"\u00a0":13,"*":-8,",":26,".":26,"\u2026":26,"c":3,"e":3,"g":3,"o":3,"q":3,"\u00e7":3,"\u00e8":3,"\u00e9":3,"\u00ea":3,"\u00eb":3,"\u00f0":3,"\u00f2":3,"\u00f3":3,"\u00f4":3,"\u00f5":3,"\u00f6":3,"\u00f8":3,"t":6,"v":-15,"y":-15,"\u00fd":-15,"\u00ff":-15,"w":-12,"x":-3}},"z":{"d":"11,-40v30,-33,54,-72,89,-100r-89,0r0,-40r141,0r0,40v-30,33,-52,73,-88,100r88,0r0,40r-141,0r0,-40","w":164,"k":{" ":11,"\u00a0":11,"-":14,"\u00ad":14,"\u2013":14,"\u2014":14,"c":3,"e":3,"g":3,"o":3,"q":3,"\u00e7":3,"\u00e8":3,"\u00e9":3,"\u00ea":3,"\u00eb":3,"\u00f0":3,"\u00f2":3,"\u00f3":3,"\u00f4":3,"\u00f5":3,"\u00f6":3,"\u00f8":3,"t":5,"\"":5,"'":5,"\u2018":5,"\u2019":5,"\u201c":5,"\u201d":5}},"{":{"d":"126,83v-44,3,-82,1,-82,-44v0,-41,17,-108,-29,-106r0,-36v69,2,-15,-148,68,-149r43,0r0,39v-21,-1,-37,-1,-37,22v0,40,12,100,-25,104r0,3v36,5,25,65,25,106v0,22,16,22,37,21r0,40","w":133,"k":{"-":13,"\u00ad":13,"\u2013":13,"\u2014":13,",":11,".":11,"\u2026":11,"A":6,"\u00c0":6,"\u00c1":6,"\u00c2":6,"\u00c3":6,"\u00c4":6,"\u00c5":6,"C":6,"G":6,"O":6,"Q":6,"\u00c7":6,"\u00d2":6,"\u00d3":6,"\u00d4":6,"\u00d5":6,"\u00d6":6,"\u00d8":6,"c":6,"e":6,"g":6,"o":6,"q":6,"\u00e7":6,"\u00e8":6,"\u00e9":6,"\u00ea":6,"\u00eb":6,"\u00f0":6,"\u00f2":6,"\u00f3":6,"\u00f4":6,"\u00f5":6,"\u00f6":6,"\u00f8":6,"t":4}},"|":{"d":"22,-252r38,0r0,299r-38,0r0,-299","w":81},"}":{"d":"13,-252v44,-2,81,-2,81,43v0,40,-16,107,29,106r0,36v-69,0,14,148,-68,150r-42,0r0,-40v20,0,36,2,36,-21v0,-40,-12,-101,26,-104r0,-4v-36,-5,-26,-64,-26,-105v0,-23,-15,-23,-36,-22r0,-39","w":133},"~":{"d":"66,-118v-17,0,-28,8,-40,18r-16,-36v18,-15,31,-24,56,-24v35,0,67,35,97,8r17,38v-14,9,-26,16,-44,17v-29,0,-43,-21,-70,-21","w":189},"\u00a0":{"w":91,"k":{"*":13,"-":16,"\u00ad":16,"\u2013":16,"\u2014":16,",":25,".":25,"\u2026":25,"A":14,"\u00c0":14,"\u00c1":14,"\u00c2":14,"\u00c3":14,"\u00c4":14,"\u00c5":14,"C":5,"G":5,"O":5,"Q":5,"\u00c7":5,"\u00d2":5,"\u00d3":5,"\u00d4":5,"\u00d5":5,"\u00d6":5,"\u00d8":5,"T":13,"V":11,"W":9,"X":11,"Y":11,"\u00dd":11,"Z":4,"v":7,"y":7,"\u00fd":7,"\u00ff":7,"w":5,"x":6,"\u00c6":8,"\"":30,"'":30,"\u2018":30,"\u2019":30,"\u201c":30,"\u201d":30}},"\u00a1":{"d":"69,72r-48,0v0,-62,-3,-127,9,-177r29,0v12,50,10,114,10,177xm45,-129v-18,0,-29,-11,-29,-28v0,-16,11,-27,29,-27v18,0,29,11,29,27v0,17,-11,28,-29,28","w":105},"\u00a2":{"d":"146,-37v11,-1,18,-5,26,-9r11,35v-8,7,-22,11,-35,13r0,34r-43,0r0,-32v-48,-7,-67,-41,-68,-94v0,-53,24,-86,68,-94r0,-32r43,0r0,32v13,1,23,6,33,10r-11,38v-7,-3,-15,-5,-24,-6r0,105xm113,-142v-39,7,-40,95,0,103r0,-103"},"\u00a3":{"d":"26,-41v34,0,51,-27,43,-62r-43,0r0,-39r24,0v-29,-52,0,-115,69,-115v28,0,52,6,71,14r-15,42v-22,-14,-87,-24,-87,20v0,18,7,28,14,39r51,0r0,39r-35,0v6,32,-12,53,-29,67v29,-8,70,-4,106,-5r0,41r-169,0r0,-41"},"\u00a4":{"d":"169,-161v12,17,12,57,0,73v18,7,28,22,41,34r-28,29v-12,-13,-28,-22,-34,-41v-18,14,-59,15,-77,0v-8,18,-23,28,-35,41r-27,-29v13,-12,22,-28,41,-34v-13,-19,-13,-54,0,-73v-18,-7,-28,-22,-41,-34r27,-29v12,13,27,23,35,41v18,-15,59,-14,76,0v8,-18,23,-28,35,-41r28,29v-13,12,-22,28,-41,34xm109,-156v-17,0,-29,14,-29,31v0,17,11,31,29,31v19,0,30,-13,30,-31v0,-18,-12,-31,-30,-31"},"\u00a5":{"d":"37,-121r33,0r-68,-131r59,0v17,41,43,72,51,121r2,0v8,-49,34,-80,50,-121r53,0r-69,131r33,0r0,28r-47,0r0,21r47,0r0,29r-47,0r0,43r-49,0r0,-43r-48,0r0,-29r48,0r0,-21r-48,0r0,-28"},"\u00a6":{"d":"22,-77r38,0r0,124r-38,0r0,-124xm60,-129r-38,0r0,-123r38,0r0,123","w":81},"\u00a7":{"d":"88,-35v22,0,33,-14,18,-25v-43,-12,-108,-28,-83,-89v5,-12,15,-21,30,-24v-42,-22,-18,-92,41,-84v24,3,53,5,68,12r-12,38v-16,-7,-67,-21,-72,4v24,32,118,20,90,100v-5,11,-16,20,-31,23v12,8,23,19,23,39v1,57,-95,52,-132,31r12,-36v13,5,28,11,48,11xm108,-97v15,-6,27,-36,6,-46v-9,-5,-21,-8,-32,-12v-17,6,-27,36,-6,46v8,4,19,8,32,12","w":190},"\u00a8":{"d":"47,-210v-14,0,-25,-11,-25,-24v0,-15,10,-26,25,-26v16,0,25,11,25,26v0,13,-10,24,-25,24xm125,-210v-15,0,-25,-11,-25,-24v0,-15,9,-26,25,-26v15,-1,27,11,26,26v0,14,-11,24,-26,24","w":172},"\u00a9":{"d":"150,26v-81,0,-130,-47,-130,-130v0,-81,50,-130,130,-130v80,0,130,49,130,130v0,81,-52,130,-130,130xm150,-201v-59,0,-95,36,-95,97v0,61,36,96,95,96v59,0,95,-35,95,-96v0,-61,-36,-97,-95,-97xm136,-104v-3,33,28,36,48,25r11,32v-44,26,-113,4,-106,-57v-5,-58,57,-87,103,-57r-11,31v-21,-10,-49,-6,-45,26","w":299},"\u00aa":{"d":"96,-211v3,-32,-48,-12,-63,-9r-8,-23v31,-13,112,-29,112,28v0,28,-5,55,2,78r-36,0v-3,-5,-1,-14,-7,-16v-14,27,-82,23,-78,-18v2,-36,39,-40,78,-40xm59,-176v0,20,34,13,37,0r0,-13v-17,-2,-37,-1,-37,13","w":156},"\u00ab":{"d":"80,-94r56,-78r25,20v-14,20,-25,44,-45,58v21,14,32,37,47,57r-25,20xm10,-93r58,-83r28,22v-15,21,-26,46,-48,60v22,14,35,38,51,58r-29,22","w":175},"\u00ac":{"d":"16,-148r159,0r0,81r-43,0r0,-41r-116,0r0,-40","w":189},"\u00ad":{"d":"19,-124r91,0r0,41r-91,0r0,-41","w":129,"k":{" ":29,"\u00a0":29,")":13,"]":13,"}":13,"*":15,"-":21,"\u00ad":21,"\u2013":21,"\u2014":21,",":42,".":42,"\u2026":42,"A":8,"\u00c0":8,"\u00c1":8,"\u00c2":8,"\u00c3":8,"\u00c4":8,"\u00c5":8,"T":25,"V":11,"W":7,"X":16,"Y":15,"\u00dd":15,"Z":4,"x":6,"\u00c6":15,"\"":67,"'":67,"\u2018":67,"\u2019":67,"\u201c":67,"\u201d":67}},"\u00ae":{"d":"124,-61v-63,0,-102,-37,-102,-101v0,-64,40,-102,102,-102v63,0,102,38,102,102v0,64,-39,101,-102,101xm124,-231v-44,0,-68,26,-68,69v0,43,25,69,68,69v44,0,68,-25,68,-69v0,-43,-25,-68,-68,-69xm123,-213v39,-7,51,52,11,53v18,8,22,30,34,44r-22,0r-23,-37r-17,-6r0,43r-19,0r0,-93v8,-2,25,-5,36,-4xm106,-170v16,0,34,1,34,-14v0,-12,-21,-15,-34,-11r0,25","w":248},"\u00af":{"d":"22,-237r116,0r0,33r-116,0r0,-33","w":159},"\u00b0":{"d":"81,-138v-36,0,-59,-21,-59,-59v1,-38,23,-60,59,-60v37,0,60,23,60,60v0,37,-24,59,-60,59xm81,-223v-13,0,-25,11,-23,26v-2,16,11,25,23,25v12,0,24,-10,24,-25v0,-15,-11,-26,-24,-26","w":157},"\u00b1":{"d":"15,-186r59,0r0,-60r42,0r0,60r59,0r0,40r-59,0r0,38r-42,0r0,-38r-59,0r0,-40xm15,-91r160,0r0,40r-160,0r0,-40","w":189},"\u00b2":{"d":"21,-276v33,-23,109,-24,107,31v-1,40,-30,57,-53,76v16,-5,38,-4,59,-4r0,36r-113,0r0,-25v24,-18,62,-38,66,-74v3,-27,-42,-18,-54,-8","w":154},"\u00b3":{"d":"135,-184v0,52,-69,58,-112,41r9,-32v18,10,60,13,61,-12v0,-20,-25,-17,-47,-17v1,-30,23,-38,41,-52v-19,3,-41,2,-62,2r0,-34r102,0r0,22v-13,15,-28,29,-43,42v30,-5,51,11,51,40","w":154},"\u00b4":{"d":"41,-259r47,0r0,11r-40,44r-26,0","w":109},"\u00b5":{"d":"144,-27v-7,30,-67,44,-84,13r-2,0v7,25,9,53,8,86r-47,0r0,-252r47,0v7,52,-22,145,33,145v23,0,35,-14,41,-32r0,-113r46,0v2,60,-5,129,6,180r-35,0v-5,-8,-5,-21,-13,-27","w":204},"\u03bc":{"d":"144,-27v-7,30,-67,44,-84,13r-2,0v7,25,9,53,8,86r-47,0r0,-252r47,0v7,52,-22,145,33,145v23,0,35,-14,41,-32r0,-113r46,0v2,60,-5,129,6,180r-35,0v-5,-8,-5,-21,-13,-27","w":204},"\u00b6":{"d":"130,-252r39,0r0,299r-39,0r0,-299xm9,-179v0,-51,33,-79,93,-73r0,299r-38,0r0,-153v-37,-3,-55,-34,-55,-73","w":190},"\u00b7":{"d":"45,-86v-17,0,-29,-12,-29,-28v0,-16,11,-27,29,-27v18,0,29,10,29,27v0,17,-12,28,-29,28","w":91},"\u00b8":{"d":"25,56v11,2,30,1,30,-10v0,-7,-10,-11,-31,-12r21,-34r30,0r-9,15v18,3,32,8,32,27v0,33,-44,37,-76,31","w":119},"\u00b9":{"d":"29,-173r35,0v1,-25,-3,-56,4,-75v-9,10,-21,18,-33,25r-17,-28r57,-40r30,0r0,118r32,0r0,36r-108,0r0,-36","w":154},"\u00ba":{"d":"78,-134v-41,0,-63,-20,-63,-61v1,-40,22,-61,63,-61v41,0,63,19,63,61v0,42,-22,61,-63,61xm78,-226v-17,0,-21,11,-21,31v0,21,7,31,21,31v17,0,21,-10,21,-31v0,-20,-4,-31,-21,-31","w":156},"\u00bb":{"d":"95,-96r-55,78r-26,-20v15,-20,26,-43,46,-58v-21,-14,-33,-37,-48,-56r25,-20xm165,-96r-57,82r-29,-22v16,-21,28,-45,49,-60v-22,-14,-35,-38,-51,-58r28,-22","w":175},"\u00bc":{"d":"60,-101v1,-37,-3,-79,3,-111v-9,10,-20,18,-32,25r-18,-28r57,-40r31,0r0,154r-41,0xm300,-28r-27,0r0,28r-37,0r0,-28r-74,0r0,-24r78,-102r33,0r0,94r27,0r0,32xm236,-60v0,-16,3,-36,1,-50v-9,22,-23,39,-39,53v11,-2,24,-4,38,-3xm219,-257r31,18r-155,244r-31,-19","w":316},"\u00bd":{"d":"60,-101v1,-37,-3,-79,3,-111v-9,10,-20,18,-32,25r-18,-28r57,-40r31,0r0,154r-41,0xm195,-139v33,-22,110,-24,108,31v-2,40,-30,57,-54,76v17,-5,38,-4,60,-4r0,36r-113,0r0,-26v24,-18,61,-37,65,-73v3,-27,-41,-18,-53,-8xm219,-257r31,18r-155,244r-31,-19","w":325},"\u00be":{"d":"309,-28r-27,0r0,28r-37,0r0,-28r-74,0r0,-24r78,-102r33,0r0,94r27,0r0,32xm245,-60v0,-16,3,-36,1,-50v-9,22,-23,39,-39,53v11,-2,24,-4,38,-3xm129,-148v0,52,-69,58,-112,41r9,-32v19,10,59,12,61,-12v0,-20,-25,-17,-47,-17v1,-30,23,-38,41,-52v-19,3,-41,2,-62,2r0,-34r102,0r0,22v-13,15,-28,30,-44,42v31,-5,52,10,52,40xm228,-257r31,18r-155,244r-31,-19","w":325},"\u00bf":{"d":"8,16v0,-67,63,-61,66,-121r40,0v6,54,-30,70,-53,97v-10,22,0,47,28,45v20,-1,36,-8,48,-17r18,35v-41,32,-147,32,-147,-39xm93,-129v-18,0,-29,-11,-29,-28v0,-16,11,-27,29,-27v18,0,29,11,29,27v0,17,-11,28,-29,28","w":163},"\u00c0":{"d":"130,-271r-38,0r-57,-31r0,-11r58,0xm146,-56r-78,0r-19,56r-49,0r91,-254r36,0r91,254r-52,0xm81,-95r54,0v-12,-29,-18,-65,-28,-96v-6,35,-16,65,-26,96","w":217},"\u00c1":{"d":"129,-313r57,0r0,11r-57,31r-38,0xm146,-56r-78,0r-19,56r-49,0r91,-254r36,0r91,254r-52,0xm81,-95r54,0v-12,-29,-18,-65,-28,-96v-6,35,-16,65,-26,96","w":217},"\u00c2":{"d":"93,-313r34,0r46,33r0,14r-36,0v-11,-7,-23,-14,-28,-27v-5,13,-18,19,-29,27r-35,0r0,-14xm146,-56r-78,0r-19,56r-49,0r91,-254r36,0r91,254r-52,0xm81,-95r54,0v-12,-29,-18,-65,-28,-96v-6,35,-16,65,-26,96","w":217},"\u00c3":{"d":"174,-282v-30,41,-95,-17,-125,17r-8,-23v22,-33,66,-18,102,-9v9,0,17,-3,22,-9xm146,-56r-78,0r-19,56r-49,0r91,-254r36,0r91,254r-52,0xm81,-95r54,0v-12,-29,-18,-65,-28,-96v-6,35,-16,65,-26,96","w":217},"\u00c4":{"d":"72,-267v-18,0,-27,-6,-27,-20v0,-14,10,-21,27,-21v16,0,27,7,27,21v0,14,-10,20,-27,20xm149,-267v-17,0,-27,-6,-27,-20v0,-14,11,-21,27,-21v17,0,27,7,27,21v0,14,-9,20,-27,20xm146,-56r-78,0r-19,56r-49,0r91,-254r36,0r91,254r-52,0xm81,-95r54,0v-12,-29,-18,-65,-28,-96v-6,35,-16,65,-26,96","w":217},"\u00c5":{"d":"89,-248v-16,-3,-26,-13,-26,-30v0,-24,20,-29,46,-32v50,-6,62,54,20,62r89,248r-52,0r-20,-56r-78,0r-19,56r-49,0xm81,-95r54,0v-12,-29,-18,-65,-28,-96v-6,35,-16,65,-26,96xm125,-278v1,-10,-6,-12,-16,-11v-11,0,-16,3,-16,11v0,7,5,12,16,12v11,0,16,-2,16,-12","w":217},"\u00c6":{"d":"142,-192v-10,35,-27,63,-43,91r45,0v-2,-29,4,-66,-2,-91xm144,-61r-67,0r-36,61r-51,0r152,-252r151,0r0,44r-100,0r0,59r91,0r0,44r-91,0r0,61r102,0r0,44r-151,0r0,-61","w":310},"\u00c7":{"d":"66,-126v-10,71,63,107,116,75r10,41v-13,10,-32,12,-53,15r-6,10v18,3,32,8,32,27v0,33,-44,38,-77,31v2,-8,-1,-21,12,-16v13,-1,22,-2,22,-11v0,-7,-10,-11,-31,-12r18,-30v-64,-9,-95,-55,-95,-130v0,-104,79,-153,175,-121r-10,41v-61,-22,-121,7,-113,80","w":201,"k":{" ":14,"\u00a0":14,"-":25,"\u00ad":25,"\u2013":25,"\u2014":25,"A":16,"\u00c0":16,"\u00c1":16,"\u00c2":16,"\u00c3":16,"\u00c4":16,"\u00c5":16,"C":12,"G":12,"O":12,"Q":12,"\u00c7":12,"\u00d2":12,"\u00d3":12,"\u00d4":12,"\u00d5":12,"\u00d6":12,"\u00d8":12,"T":16,"V":24,"W":9,"X":18,"Y":20,"\u00dd":20,"Z":18,"c":13,"e":13,"g":13,"o":13,"q":13,"\u00e7":13,"\u00e8":13,"\u00e9":13,"\u00ea":13,"\u00eb":13,"\u00f0":13,"\u00f2":13,"\u00f3":13,"\u00f4":13,"\u00f5":13,"\u00f6":13,"\u00f8":13,"t":13,"v":19,"y":19,"\u00fd":19,"\u00ff":19,"w":14,"x":16,"z":6,"\u00c6":44,"a":4,"m":4,"n":4,"p":4,"r":4,"s":4,"u":4,"\u00e6":4}},"\u00c8":{"d":"127,-271r-38,0r-57,-31r0,-11r57,0xm22,-252r149,0r0,44r-100,0r0,59r91,0r0,44r-91,0r0,61r102,0r0,44r-151,0r0,-252","w":187},"\u00c9":{"d":"105,-313r58,0r0,11r-58,31r-37,0xm22,-252r149,0r0,44r-100,0r0,59r91,0r0,44r-91,0r0,61r102,0r0,44r-151,0r0,-252","w":187},"\u00ca":{"d":"79,-313r34,0r46,33r0,14r-36,0v-11,-7,-22,-14,-27,-27v-6,13,-19,19,-30,27r-35,0r0,-14xm22,-252r149,0r0,44r-100,0r0,59r91,0r0,44r-91,0r0,61r102,0r0,44r-151,0r0,-252","w":187},"\u00cb":{"d":"85,-287v2,21,-35,26,-48,15v-16,-13,-4,-36,21,-36v16,0,26,8,27,21xm134,-267v-17,0,-27,-7,-27,-20v0,-13,11,-21,27,-21v18,0,26,7,28,21v-1,14,-10,20,-28,20xm22,-252r149,0r0,44r-100,0r0,59r91,0r0,44r-91,0r0,61r102,0r0,44r-151,0r0,-252","w":187},"\u00cc":{"d":"76,-271r-37,0r-57,-31r0,-11r57,0xm27,-252r49,0r0,252r-49,0r0,-252","w":102},"\u00cd":{"d":"65,-313r57,0r0,11r-57,31r-37,0xm27,-252r49,0r0,252r-49,0r0,-252","w":102},"\u00ce":{"d":"35,-313r34,0r46,33r0,14r-35,0v-11,-7,-23,-13,-28,-27v-6,13,-19,19,-30,27r-35,0r0,-14xm27,-252r49,0r0,252r-49,0r0,-252","w":102},"\u00cf":{"d":"41,-287v2,21,-35,26,-48,15v-16,-13,-4,-36,21,-36v16,0,26,8,27,21xm90,-267v-17,0,-27,-7,-27,-20v0,-13,11,-21,27,-21v18,0,26,7,28,21v-1,14,-10,20,-28,20xm27,-252r49,0r0,252r-49,0r0,-252","w":102},"\u00d0":{"d":"227,-128v0,110,-84,147,-197,128r0,-116r-32,0r0,-28r32,0r0,-108v21,-4,50,-4,73,-4v83,0,124,45,124,128xm175,-128v0,-60,-32,-94,-96,-82r0,66r50,0r0,28r-50,0r0,75v66,9,96,-25,96,-87","w":240,"k":{"J":8," ":5,"\u00a0":5,")":6,"]":6,"}":6,"*":4,",":11,".":11,"\u2026":11,"A":10,"\u00c0":10,"\u00c1":10,"\u00c2":10,"\u00c3":10,"\u00c4":10,"\u00c5":10,"T":14,"V":13,"W":10,"X":20,"Y":17,"\u00dd":17,"Z":9,"v":3,"y":3,"\u00fd":3,"\u00ff":3,"x":11,"z":6,"\u00c6":22,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14}},"\u00d1":{"d":"183,-282v-30,41,-95,-17,-125,17r-8,-23v22,-33,66,-18,102,-9v9,0,17,-3,22,-9xm179,2v-39,-57,-83,-109,-116,-173v9,50,4,113,5,171r-46,0r0,-254r36,0v38,58,84,107,114,173r2,0v-10,-49,-5,-113,-6,-171r47,0r0,254r-36,0","w":236},"\u00d2":{"d":"148,-271r-37,0r-57,-31r0,-11r57,0xm121,5v-77,0,-106,-53,-107,-131v-1,-78,33,-131,107,-131v77,0,105,54,107,131v2,78,-35,131,-107,131xm121,-213v-42,0,-56,36,-55,87v1,46,10,87,55,87v43,0,55,-36,55,-87v0,-46,-11,-87,-55,-87","w":241,"k":{"J":8," ":5,"\u00a0":5,")":6,"]":6,"}":6,"*":4,",":11,".":11,"\u2026":11,"A":10,"\u00c0":10,"\u00c1":10,"\u00c2":10,"\u00c3":10,"\u00c4":10,"\u00c5":10,"T":14,"V":13,"W":10,"X":20,"Y":17,"\u00dd":17,"Z":9,"v":3,"y":3,"\u00fd":3,"\u00ff":3,"x":11,"z":6,"\u00c6":22,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14}},"\u00d3":{"d":"132,-313r58,0r0,11r-58,31r-37,0xm121,5v-77,0,-106,-53,-107,-131v-1,-78,33,-131,107,-131v77,0,105,54,107,131v2,78,-35,131,-107,131xm121,-213v-42,0,-56,36,-55,87v1,46,10,87,55,87v43,0,55,-36,55,-87v0,-46,-11,-87,-55,-87","w":241,"k":{"J":8," ":5,"\u00a0":5,")":6,"]":6,"}":6,"*":4,",":11,".":11,"\u2026":11,"A":10,"\u00c0":10,"\u00c1":10,"\u00c2":10,"\u00c3":10,"\u00c4":10,"\u00c5":10,"T":14,"V":13,"W":10,"X":20,"Y":17,"\u00dd":17,"Z":9,"v":3,"y":3,"\u00fd":3,"\u00ff":3,"x":11,"z":6,"\u00c6":22,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14}},"\u00d4":{"d":"103,-313r35,0r46,33r0,14r-36,0v-11,-7,-23,-13,-28,-27v-5,14,-19,19,-30,27r-35,0r0,-14xm121,5v-77,0,-106,-53,-107,-131v-1,-78,33,-131,107,-131v77,0,105,54,107,131v2,78,-35,131,-107,131xm121,-213v-42,0,-56,36,-55,87v1,46,10,87,55,87v43,0,55,-36,55,-87v0,-46,-11,-87,-55,-87","w":241,"k":{"J":8," ":5,"\u00a0":5,")":6,"]":6,"}":6,"*":4,",":11,".":11,"\u2026":11,"A":10,"\u00c0":10,"\u00c1":10,"\u00c2":10,"\u00c3":10,"\u00c4":10,"\u00c5":10,"T":14,"V":13,"W":10,"X":20,"Y":17,"\u00dd":17,"Z":9,"v":3,"y":3,"\u00fd":3,"\u00ff":3,"x":11,"z":6,"\u00c6":22,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14}},"\u00d5":{"d":"185,-282v-30,41,-95,-17,-125,17r-8,-23v22,-33,66,-18,102,-9v9,0,17,-3,22,-9xm121,5v-77,0,-106,-53,-107,-131v-1,-78,33,-131,107,-131v77,0,105,54,107,131v2,78,-35,131,-107,131xm121,-213v-42,0,-56,36,-55,87v1,46,10,87,55,87v43,0,55,-36,55,-87v0,-46,-11,-87,-55,-87","w":241,"k":{"J":8," ":5,"\u00a0":5,")":6,"]":6,"}":6,"*":4,",":11,".":11,"\u2026":11,"A":10,"\u00c0":10,"\u00c1":10,"\u00c2":10,"\u00c3":10,"\u00c4":10,"\u00c5":10,"T":14,"V":13,"W":10,"X":20,"Y":17,"\u00dd":17,"Z":9,"v":3,"y":3,"\u00fd":3,"\u00ff":3,"x":11,"z":6,"\u00c6":22,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14}},"\u00d6":{"d":"81,-267v-18,0,-27,-6,-27,-20v0,-14,10,-21,27,-21v16,0,27,7,27,21v0,14,-10,20,-27,20xm158,-267v-17,0,-27,-7,-27,-20v0,-13,11,-21,27,-21v17,0,27,7,27,21v0,14,-9,20,-27,20xm121,5v-77,0,-106,-53,-107,-131v-1,-78,33,-131,107,-131v77,0,105,54,107,131v2,78,-35,131,-107,131xm121,-213v-42,0,-56,36,-55,87v1,46,10,87,55,87v43,0,55,-36,55,-87v0,-46,-11,-87,-55,-87","w":241,"k":{"J":8," ":5,"\u00a0":5,")":6,"]":6,"}":6,"*":4,",":11,".":11,"\u2026":11,"A":10,"\u00c0":10,"\u00c1":10,"\u00c2":10,"\u00c3":10,"\u00c4":10,"\u00c5":10,"T":14,"V":13,"W":10,"X":20,"Y":17,"\u00dd":17,"Z":9,"v":3,"y":3,"\u00fd":3,"\u00ff":3,"x":11,"z":6,"\u00c6":22,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14}},"\u00d7":{"d":"48,-197r47,47r47,-47r29,29r-47,46r47,46r-29,30r-47,-47r-47,47r-29,-29r48,-47r-47,-46","w":189},"\u00d8":{"d":"228,-126v7,99,-74,158,-160,119r-8,12r-31,-19r11,-17v-18,-23,-23,-54,-26,-95v-7,-101,77,-159,161,-117r9,-14r31,18r-13,20v16,23,23,55,26,93xm150,-203v-64,-39,-102,46,-79,123xm93,-47v66,35,99,-48,78,-122","w":241,"k":{"J":8," ":5,"\u00a0":5,")":6,"]":6,"}":6,"*":4,",":11,".":11,"\u2026":11,"A":10,"\u00c0":10,"\u00c1":10,"\u00c2":10,"\u00c3":10,"\u00c4":10,"\u00c5":10,"T":14,"V":13,"W":10,"X":20,"Y":17,"\u00dd":17,"Z":9,"v":3,"y":3,"\u00fd":3,"\u00ff":3,"x":11,"z":6,"\u00c6":22,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14}},"\u00d9":{"d":"142,-271r-38,0r-56,-31r0,-11r57,0xm116,-40v33,-1,42,-18,42,-53r0,-159r47,0r0,163v0,60,-29,93,-89,93v-64,0,-95,-29,-95,-87r0,-169r49,0r0,159v0,34,10,55,46,53","w":225},"\u00da":{"d":"131,-313r58,0r0,11r-58,31r-37,0xm116,-40v33,-1,42,-18,42,-53r0,-159r47,0r0,163v0,60,-29,93,-89,93v-64,0,-95,-29,-95,-87r0,-169r49,0r0,159v0,34,10,55,46,53","w":225},"\u00db":{"d":"98,-313r35,0r46,33r0,14r-36,0v-11,-7,-23,-13,-28,-27v-5,14,-19,19,-30,27r-35,0r0,-14xm116,-40v33,-1,42,-18,42,-53r0,-159r47,0r0,163v0,60,-29,93,-89,93v-64,0,-95,-29,-95,-87r0,-169r49,0r0,159v0,34,10,55,46,53","w":225},"\u00dc":{"d":"75,-267v-18,0,-27,-6,-27,-20v0,-14,10,-21,27,-21v16,0,27,7,27,21v0,14,-10,20,-27,20xm152,-267v-17,0,-27,-6,-27,-20v0,-14,11,-21,27,-21v17,0,27,7,27,21v0,14,-9,20,-27,20xm116,-40v33,-1,42,-18,42,-53r0,-159r47,0r0,163v0,60,-29,93,-89,93v-64,0,-95,-29,-95,-87r0,-169r49,0r0,159v0,34,10,55,46,53","w":225},"\u00dd":{"d":"117,-313r58,0r0,11r-58,31r-37,0xm82,-94r-83,-158r59,0v17,41,43,72,51,121r2,0v8,-49,34,-80,50,-121r53,0r-83,158r0,94r-49,0r0,-94","w":213,"k":{"\u00ff":17,"\u00fc":20,"\u00fb":20,"\u00fa":20,"\u00f6":38,"\u00f5":38,"\u00f4":38,"\u00f2":38,"\u00f1":20,"\u00ef":20,"\u00ee":20,"\u00ec":20,"\u00eb":38,"\u00ea":38,"\u00e8":38,"\u00e5":20,"\u00e4":20,"\u00e2":20,"\u00e1":20," ":10,"\u00a0":10,"*":-9,"-":24,"\u00ad":24,"\u2013":24,"\u2014":24,",":42,".":42,"\u2026":42,"A":32,"\u00c0":32,"\u00c1":32,"\u00c2":32,"\u00c3":32,"\u00c4":32,"\u00c5":32,"C":17,"G":17,"O":17,"Q":17,"\u00c7":17,"\u00d2":17,"\u00d3":17,"\u00d4":17,"\u00d5":17,"\u00d6":17,"\u00d8":17,"T":25,"V":15,"W":11,"X":15,"Y":15,"\u00dd":15,"Z":21,"c":38,"e":38,"g":38,"o":38,"q":38,"\u00e7":38,"\u00e9":38,"\u00f0":38,"\u00f3":38,"\u00f8":38,"t":18,"v":17,"y":17,"\u00fd":17,"w":14,"x":22,"z":25,"\u00c6":44,"\"":-13,"'":-13,"\u2018":-13,"\u2019":-13,"\u201c":-13,"\u201d":-13,"\u00ae":-6,"\u2122":-6,"a":26,"m":26,"n":26,"p":26,"r":26,"s":26,"u":26,"\u00e6":26,"\u00e0":20,"\u00e3":20,"\u00ed":20,"\u00f9":20}},"\u00de":{"d":"197,-172v0,70,-58,94,-126,85r0,87r-49,0r0,-288r49,0r0,33v70,-5,126,13,126,83xm145,-173v0,-38,-39,-44,-74,-38r0,81v36,6,74,-2,74,-43","w":205,"k":{" ":14,"\u00a0":14,"-":4,"\u00ad":4,"\u2013":4,"\u2014":4,",":47,".":47,"\u2026":47,"A":28,"\u00c0":28,"\u00c1":28,"\u00c2":28,"\u00c3":28,"\u00c4":28,"\u00c5":28,"C":4,"G":4,"O":4,"Q":4,"\u00c7":4,"\u00d2":4,"\u00d3":4,"\u00d4":4,"\u00d5":4,"\u00d6":4,"\u00d8":4,"T":3,"V":4,"W":3,"X":19,"Y":10,"\u00dd":10,"Z":7,"c":13,"e":13,"g":13,"o":13,"q":13,"\u00e7":13,"\u00e8":13,"\u00e9":13,"\u00ea":13,"\u00eb":13,"\u00f0":13,"\u00f2":13,"\u00f3":13,"\u00f4":13,"\u00f5":13,"\u00f6":13,"\u00f8":13,"x":13,"z":5,"\u00c6":47,"a":10,"m":10,"n":10,"p":10,"r":10,"s":10,"u":10,"\u00e6":10,"\u00e0":4,"\u00e1":4,"\u00e2":4,"\u00e3":4,"\u00e4":4,"\u00e5":4,"\u00ec":4,"\u00ed":4,"\u00ee":4,"\u00ef":4,"\u00f1":4,"\u00f9":4,"\u00fa":4,"\u00fb":4,"\u00fc":4}},"\u00df":{"d":"124,-210v-24,-11,-56,-6,-48,30r0,180r-47,0r0,-140r-25,0r0,-40r25,0v-11,-69,50,-90,105,-66xm111,-46v17,15,92,24,67,-15v-29,-18,-76,-20,-76,-69v0,-63,83,-64,125,-41r-11,34v-17,-12,-86,-18,-61,16v29,17,76,19,76,67v0,65,-89,70,-133,43","w":240},"\u00e0":{"d":"113,-107v14,-53,-55,-38,-82,-28r-12,-35v49,-20,141,-28,141,49v0,41,-8,88,4,121r-38,0v-4,-7,-3,-19,-10,-24v-20,40,-113,35,-108,-26v4,-50,50,-60,105,-57xm57,-57v0,34,49,21,56,2r0,-24v-24,-1,-56,-2,-56,22xm112,-204r-26,0r-44,-44r0,-11r49,0","w":178},"\u00e1":{"d":"113,-107v14,-53,-55,-38,-82,-28r-12,-35v49,-20,141,-28,141,49v0,41,-8,88,4,121r-38,0v-4,-7,-3,-19,-10,-24v-20,40,-113,35,-108,-26v4,-50,50,-60,105,-57xm57,-57v0,34,49,21,56,2r0,-24v-24,-1,-56,-2,-56,22xm86,-259r47,0r0,11r-40,44r-26,0","w":178},"\u00e2":{"d":"78,-264r31,0r40,66r-37,0v-8,-13,-16,-26,-21,-41v-4,17,-14,28,-22,41r-36,0xm113,-107v14,-53,-55,-38,-82,-28r-12,-35v49,-20,141,-28,141,49v0,41,-8,88,4,121r-38,0v-4,-7,-3,-19,-10,-24v-20,40,-113,35,-108,-26v4,-50,50,-60,105,-57xm57,-57v0,34,49,21,56,2r0,-24v-24,-1,-56,-2,-56,22","w":178},"\u00e3":{"d":"150,-229v-26,47,-83,-15,-112,16r-7,-24v12,-14,21,-23,39,-23v28,0,50,29,73,6xm113,-107v14,-53,-55,-38,-82,-28r-12,-35v49,-20,141,-28,141,49v0,41,-8,88,4,121r-38,0v-4,-7,-3,-19,-10,-24v-20,40,-113,35,-108,-26v4,-50,50,-60,105,-57xm57,-57v0,34,49,21,56,2r0,-24v-24,-1,-56,-2,-56,22","w":178},"\u00e4":{"d":"113,-107v14,-53,-55,-38,-82,-28r-12,-35v49,-20,141,-28,141,49v0,41,-8,88,4,121r-38,0v-4,-7,-3,-19,-10,-24v-20,40,-113,35,-108,-26v4,-50,50,-60,105,-57xm57,-57v0,34,49,21,56,2r0,-24v-24,-1,-56,-2,-56,22xm52,-210v-14,0,-25,-11,-25,-24v0,-15,10,-26,25,-26v16,0,25,11,25,26v0,13,-10,24,-25,24xm130,-210v-15,0,-25,-11,-25,-24v0,-15,9,-26,25,-26v15,-1,27,11,26,26v0,14,-11,24,-26,24","w":178},"\u00e5":{"d":"92,-199v-24,0,-40,-12,-40,-34v0,-22,16,-34,40,-34v24,0,40,11,40,34v0,19,-18,34,-40,34xm92,-245v-7,0,-14,4,-14,12v0,8,7,12,14,12v7,0,14,-4,14,-12v0,-8,-7,-12,-14,-12xm113,-107v14,-53,-55,-38,-82,-28r-12,-35v49,-20,141,-28,141,49v0,41,-8,88,4,121r-38,0v-4,-7,-3,-19,-10,-24v-20,40,-113,35,-108,-26v4,-50,50,-60,105,-57xm57,-57v0,34,49,21,56,2r0,-24v-24,-1,-56,-2,-56,22","w":178},"\u00e6":{"d":"57,-57v0,34,49,21,56,2r0,-24v-24,-1,-56,-2,-56,22xm264,-15v-32,27,-118,28,-136,-12v-18,13,-31,32,-65,30v-33,-2,-55,-19,-55,-53v0,-50,50,-60,105,-57v14,-54,-56,-38,-81,-25r-13,-34v30,-16,103,-32,124,2v43,-44,148,-17,126,68r-3,18r-108,0v-5,51,62,55,91,32xm227,-107v9,-39,-36,-52,-57,-30v-6,7,-10,18,-11,30r68,0","w":282},"\u00e7":{"d":"102,-36v15,0,27,-5,35,-11r11,36v-11,8,-24,13,-41,15r-7,11v18,3,32,8,32,27v0,34,-45,37,-77,31v3,-7,0,-20,12,-16v13,-1,22,-2,22,-11v0,-7,-10,-11,-31,-12r18,-30v-47,-6,-64,-41,-64,-94v0,-80,65,-115,134,-84r-11,39v-35,-19,-80,-6,-75,45v3,30,11,54,42,54","w":155,"k":{" ":9,"\u00a0":9,")":4,"]":4,"}":4,"-":14,"\u00ad":14,"\u2013":14,"\u2014":14,"c":6,"e":6,"g":6,"o":6,"q":6,"\u00e7":6,"\u00e8":6,"\u00e9":6,"\u00ea":6,"\u00eb":6,"\u00f0":6,"\u00f2":6,"\u00f3":6,"\u00f4":6,"\u00f5":6,"\u00f6":6,"\u00f8":6,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"w":6,"x":3,"z":3,"\"":8,"'":8,"\u2018":8,"\u2019":8,"\u201c":8,"\u201d":8}},"\u00e8":{"d":"59,-78v-6,52,62,54,90,32r16,31v-15,11,-42,20,-69,20v-59,1,-83,-36,-84,-95v0,-60,29,-94,86,-95v59,-1,81,46,69,107r-108,0xm127,-107v9,-39,-36,-52,-57,-30v-6,7,-9,18,-10,30r67,0xm118,-204r-26,0r-44,-44r0,-11r49,0","w":182,"k":{")":5,"]":5,"}":5,"*":8,"c":2,"e":2,"g":2,"o":2,"q":2,"\u00e7":2,"\u00e8":2,"\u00e9":2,"\u00ea":2,"\u00eb":2,"\u00f0":2,"\u00f2":2,"\u00f3":2,"\u00f4":2,"\u00f5":2,"\u00f6":2,"\u00f8":2,"v":5,"y":5,"\u00fd":5,"\u00ff":5,"w":2,"x":8,"z":2,"\"":18,"'":18,"\u2018":18,"\u2019":18,"\u201c":18,"\u201d":18,"\u00ae":8,"\u2122":8}},"\u00e9":{"d":"59,-78v-6,52,62,54,90,32r16,31v-15,11,-42,20,-69,20v-59,1,-83,-36,-84,-95v0,-60,29,-94,86,-95v59,-1,81,46,69,107r-108,0xm127,-107v9,-39,-36,-52,-57,-30v-6,7,-9,18,-10,30r67,0xm99,-259r47,0r0,11r-40,44r-26,0","w":182,"k":{")":5,"]":5,"}":5,"*":8,"c":2,"e":2,"g":2,"o":2,"q":2,"\u00e7":2,"\u00e8":2,"\u00e9":2,"\u00ea":2,"\u00eb":2,"\u00f0":2,"\u00f2":2,"\u00f3":2,"\u00f4":2,"\u00f5":2,"\u00f6":2,"\u00f8":2,"v":5,"y":5,"\u00fd":5,"\u00ff":5,"w":2,"x":8,"z":2,"\"":18,"'":18,"\u2018":18,"\u2019":18,"\u201c":18,"\u201d":18,"\u00ae":8,"\u2122":8}},"\u00ea":{"d":"80,-264r31,0r39,66r-37,0v-8,-13,-16,-25,-20,-41v-4,17,-14,28,-22,41r-36,0xm59,-78v-6,52,62,54,90,32r16,31v-15,11,-42,20,-69,20v-59,1,-83,-36,-84,-95v0,-60,29,-94,86,-95v59,-1,81,46,69,107r-108,0xm127,-107v9,-39,-36,-52,-57,-30v-6,7,-9,18,-10,30r67,0","w":182,"k":{")":5,"]":5,"}":5,"*":8,"c":2,"e":2,"g":2,"o":2,"q":2,"\u00e7":2,"\u00e8":2,"\u00e9":2,"\u00ea":2,"\u00eb":2,"\u00f0":2,"\u00f2":2,"\u00f3":2,"\u00f4":2,"\u00f5":2,"\u00f6":2,"\u00f8":2,"v":5,"y":5,"\u00fd":5,"\u00ff":5,"w":2,"x":8,"z":2,"\"":18,"'":18,"\u2018":18,"\u2019":18,"\u201c":18,"\u201d":18,"\u00ae":8,"\u2122":8}},"\u00eb":{"d":"59,-78v-6,52,62,54,90,32r16,31v-15,11,-42,20,-69,20v-59,1,-83,-36,-84,-95v0,-60,29,-94,86,-95v59,-1,81,46,69,107r-108,0xm127,-107v9,-39,-36,-52,-57,-30v-6,7,-9,18,-10,30r67,0xm55,-210v-14,0,-25,-11,-25,-24v0,-15,10,-26,25,-26v16,0,25,11,25,26v0,13,-10,24,-25,24xm133,-210v-15,0,-25,-11,-25,-24v0,-15,9,-26,25,-26v15,-1,27,11,26,26v0,14,-11,24,-26,24","w":182,"k":{")":5,"]":5,"}":5,"*":8,"c":2,"e":2,"g":2,"o":2,"q":2,"\u00e7":2,"\u00e8":2,"\u00e9":2,"\u00ea":2,"\u00eb":2,"\u00f0":2,"\u00f2":2,"\u00f3":2,"\u00f4":2,"\u00f5":2,"\u00f6":2,"\u00f8":2,"v":5,"y":5,"\u00fd":5,"\u00ff":5,"w":2,"x":8,"z":2,"\"":18,"'":18,"\u2018":18,"\u2019":18,"\u201c":18,"\u201d":18,"\u00ae":8,"\u2122":8}},"\u00ec":{"d":"25,-180r47,0r0,180r-47,0r0,-180xm70,-204r-26,0r-44,-44r0,-11r49,0","w":97},"\u00ed":{"d":"25,-180r47,0r0,180r-47,0r0,-180xm45,-259r47,0r0,11r-40,44r-26,0","w":97},"\u00ee":{"d":"33,-264r31,0r40,66r-37,0v-8,-13,-16,-25,-20,-41v-4,17,-14,28,-22,41r-36,0xm25,-180r47,0r0,180r-47,0r0,-180","w":97},"\u00ef":{"d":"25,-180r47,0r0,180r-47,0r0,-180xm9,-210v-14,0,-25,-11,-25,-24v0,-15,10,-26,25,-26v16,0,25,11,25,26v0,13,-10,24,-25,24xm87,-210v-15,0,-25,-11,-25,-24v0,-15,9,-26,25,-26v15,-1,27,11,26,26v0,14,-11,24,-26,24","w":97,"k":{"\u2122":-11,"\u00ae":-11}},"\u00f0":{"d":"13,-88v-3,-70,70,-116,129,-77v-4,-24,-19,-41,-38,-50r-10,25r-24,-9r10,-24v-10,-2,-20,-2,-31,-2r0,-32v17,-1,32,0,45,2r10,-22r23,10r-9,19v92,23,107,257,-19,253v-57,-1,-84,-36,-86,-93xm103,-140v-29,-1,-44,24,-44,53v-1,31,15,52,43,52v34,-1,42,-37,42,-78v0,-23,-21,-26,-41,-27","w":202},"\u00f1":{"d":"158,-229v-26,47,-84,-15,-113,16r-6,-24v11,-14,20,-23,38,-23v28,0,51,29,74,6xm122,-185v81,0,49,111,55,185r-46,0r0,-102v8,-53,-55,-51,-64,-15r0,117r-46,0r0,-180r37,0v3,7,2,18,6,24v12,-16,30,-29,58,-29","w":194},"\u00f2":{"d":"97,5v-58,0,-85,-37,-85,-95v-1,-58,29,-95,85,-95v58,0,84,37,84,95v1,58,-29,95,-84,95xm97,-145v-29,0,-37,22,-37,55v0,30,8,55,37,55v28,0,36,-22,36,-55v0,-31,-8,-55,-36,-55xm119,-204r-26,0r-44,-44r0,-11r49,0","w":192,"k":{"f":4,")":6,"]":6,"}":6,"*":7,",":4,".":4,"\u2026":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":3,"x":9,"z":3,"\"":27,"'":27,"\u2018":27,"\u2019":27,"\u201c":27,"\u201d":27,"\u00ae":6,"\u2122":6}},"\u00f3":{"d":"97,5v-58,0,-85,-37,-85,-95v-1,-58,29,-95,85,-95v58,0,84,37,84,95v1,58,-29,95,-84,95xm97,-145v-29,0,-37,22,-37,55v0,30,8,55,37,55v28,0,36,-22,36,-55v0,-31,-8,-55,-36,-55xm99,-259r47,0r0,11r-40,44r-26,0","w":192,"k":{"f":4,")":6,"]":6,"}":6,"*":7,",":4,".":4,"\u2026":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":3,"x":9,"z":3,"\"":27,"'":27,"\u2018":27,"\u2019":27,"\u201c":27,"\u201d":27,"\u00ae":6,"\u2122":6}},"\u00f4":{"d":"83,-264r31,0r40,66r-37,0v-8,-13,-16,-26,-21,-41v-4,17,-14,28,-22,41r-35,0xm97,5v-58,0,-85,-37,-85,-95v-1,-58,29,-95,85,-95v58,0,84,37,84,95v1,58,-29,95,-84,95xm97,-145v-29,0,-37,22,-37,55v0,30,8,55,37,55v28,0,36,-22,36,-55v0,-31,-8,-55,-36,-55","w":192,"k":{"f":4,")":6,"]":6,"}":6,"*":7,",":4,".":4,"\u2026":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":3,"x":9,"z":3,"\"":27,"'":27,"\u2018":27,"\u2019":27,"\u201c":27,"\u201d":27,"\u00ae":6,"\u2122":6}},"\u00f5":{"d":"120,-209v-27,0,-55,-29,-76,-4r-7,-24v12,-14,21,-23,39,-23v28,0,50,29,73,6r8,25v-11,12,-19,20,-37,20xm97,5v-58,0,-85,-37,-85,-95v-1,-58,29,-95,85,-95v58,0,84,37,84,95v1,58,-29,95,-84,95xm97,-145v-29,0,-37,22,-37,55v0,30,8,55,37,55v28,0,36,-22,36,-55v0,-31,-8,-55,-36,-55","w":192,"k":{"f":4,")":6,"]":6,"}":6,"*":7,",":4,".":4,"\u2026":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":3,"x":9,"z":3,"\"":27,"'":27,"\u2018":27,"\u2019":27,"\u201c":27,"\u201d":27,"\u00ae":6,"\u2122":6}},"\u00f6":{"d":"97,5v-58,0,-85,-37,-85,-95v-1,-58,29,-95,85,-95v58,0,84,37,84,95v1,58,-29,95,-84,95xm97,-145v-29,0,-37,22,-37,55v0,30,8,55,37,55v28,0,36,-22,36,-55v0,-31,-8,-55,-36,-55xm57,-210v-14,0,-25,-11,-25,-24v0,-15,10,-26,25,-26v16,0,25,11,25,26v0,13,-10,24,-25,24xm135,-210v-15,0,-25,-11,-25,-24v0,-15,9,-26,25,-26v15,-1,27,11,26,26v0,14,-11,24,-26,24","w":192,"k":{"f":4,")":6,"]":6,"}":6,"*":7,",":4,".":4,"\u2026":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":3,"x":9,"z":3,"\"":27,"'":27,"\u2018":27,"\u2019":27,"\u201c":27,"\u201d":27,"\u00ae":6,"\u2122":6}},"\u00f7":{"d":"15,-142r160,0r0,40r-160,0r0,-40xm95,-165v-18,0,-29,-11,-29,-27v0,-16,12,-28,29,-28v18,0,30,11,30,28v0,17,-12,27,-30,27xm95,-22v-17,0,-29,-12,-29,-28v0,-16,11,-27,29,-27v18,0,30,10,30,27v0,17,-12,28,-30,28","w":189},"\u00f8":{"d":"181,-90v0,75,-62,114,-126,86r-9,13r-30,-22r11,-15v-33,-59,-11,-164,69,-157v17,1,28,2,40,8r8,-12r29,21r-10,14v12,15,18,37,18,64xm76,-41v42,24,69,-26,54,-75xm115,-140v-41,-21,-64,25,-53,73","w":192,"k":{"f":4,")":6,"]":6,"}":6,"*":7,",":4,".":4,"\u2026":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":3,"x":9,"z":3,"\"":27,"'":27,"\u2018":27,"\u2019":27,"\u201c":27,"\u201d":27,"\u00ae":6,"\u2122":6}},"\u00f9":{"d":"76,5v-83,0,-51,-110,-57,-185r47,0r0,102v-10,55,60,50,60,14r0,-116r47,0v1,61,-5,129,6,180r-35,0v-4,-9,-5,-20,-10,-27v-11,17,-31,32,-58,32xm114,-204r-26,0r-44,-44r0,-11r49,0","w":193},"\u00fa":{"d":"76,5v-83,0,-51,-110,-57,-185r47,0r0,102v-10,55,60,50,60,14r0,-116r47,0v1,61,-5,129,6,180r-35,0v-4,-9,-5,-20,-10,-27v-11,17,-31,32,-58,32xm94,-259r47,0r0,11r-40,44r-26,0","w":193},"\u00fb":{"d":"84,-264r30,0r40,66r-37,0v-8,-13,-16,-25,-20,-41v-4,17,-14,28,-22,41r-36,0xm76,5v-83,0,-51,-110,-57,-185r47,0r0,102v-10,55,60,50,60,14r0,-116r47,0v1,61,-5,129,6,180r-35,0v-4,-9,-5,-20,-10,-27v-11,17,-31,32,-58,32","w":193},"\u00fc":{"d":"76,5v-83,0,-51,-110,-57,-185r47,0r0,102v-10,55,60,50,60,14r0,-116r47,0v1,61,-5,129,6,180r-35,0v-4,-9,-5,-20,-10,-27v-11,17,-31,32,-58,32xm57,-210v-14,0,-25,-11,-25,-24v0,-15,10,-26,25,-26v16,0,25,11,25,26v0,13,-10,24,-25,24xm135,-210v-15,0,-25,-11,-25,-24v0,-15,9,-26,25,-26v15,-1,27,11,26,26v0,14,-11,24,-26,24","w":193},"\u00fd":{"d":"53,-180v15,42,24,90,42,129v6,-48,21,-86,32,-129r48,0r-68,199v-10,35,-39,69,-82,49r8,-38v23,7,34,-9,39,-30r-75,-180r56,0xm92,-259r47,0r0,11r-40,44r-26,0","w":172,"k":{" ":13,"\u00a0":13,"*":-8,",":26,".":26,"\u2026":26,"c":3,"e":3,"g":3,"o":3,"q":3,"\u00e7":3,"\u00e8":3,"\u00e9":3,"\u00ea":3,"\u00eb":3,"\u00f0":3,"\u00f2":3,"\u00f3":3,"\u00f4":3,"\u00f5":3,"\u00f6":3,"\u00f8":3,"t":6,"v":-15,"y":-15,"\u00fd":-15,"\u00ff":-15,"w":-12,"x":-3}},"\u00fe":{"d":"183,-95v2,70,-50,118,-116,93r0,74r-46,0r0,-324r46,0v2,28,-4,63,2,87v11,-12,23,-20,46,-20v52,1,66,33,68,90xm134,-96v-3,-28,-7,-49,-33,-49v-46,-2,-32,59,-34,102v34,21,73,-2,67,-53","w":194,"k":{"f":4,")":6,"]":6,"}":6,"*":7,",":4,".":4,"\u2026":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":3,"x":9,"z":3,"\"":27,"'":27,"\u2018":27,"\u2019":27,"\u201c":27,"\u201d":27,"\u00ae":6,"\u2122":6}},"\u00ff":{"d":"53,-180v15,42,24,90,42,129v6,-48,21,-86,32,-129r48,0r-68,199v-10,35,-39,69,-82,49r8,-38v23,7,34,-9,39,-30r-75,-180r56,0xm49,-210v-14,0,-25,-11,-25,-24v0,-15,10,-26,25,-26v16,0,25,11,25,26v0,13,-10,24,-25,24xm127,-210v-15,0,-25,-11,-25,-24v0,-15,9,-26,25,-26v15,-1,27,11,26,26v0,14,-11,24,-26,24","w":172,"k":{" ":13,"\u00a0":13,"*":-8,",":26,".":26,"\u2026":26,"c":3,"e":3,"g":3,"o":3,"q":3,"\u00e7":3,"\u00e8":3,"\u00e9":3,"\u00ea":3,"\u00eb":3,"\u00f0":3,"\u00f2":3,"\u00f3":3,"\u00f4":3,"\u00f5":3,"\u00f6":3,"\u00f8":3,"t":6,"v":-15,"y":-15,"\u00fd":-15,"\u00ff":-15,"w":-12,"x":-3}},"\u2013":{"d":"39,-125r159,0r0,42r-159,0r0,-42","w":237,"k":{" ":29,"\u00a0":29,")":13,"]":13,"}":13,"*":15,"-":21,"\u00ad":21,"\u2013":21,"\u2014":21,",":42,".":42,"\u2026":42,"A":8,"\u00c0":8,"\u00c1":8,"\u00c2":8,"\u00c3":8,"\u00c4":8,"\u00c5":8,"T":25,"V":11,"W":7,"X":16,"Y":15,"\u00dd":15,"Z":4,"x":6,"\u00c6":15,"\"":67,"'":67,"\u2018":67,"\u2019":67,"\u201c":67,"\u201d":67}},"\u2014":{"d":"39,-125r217,0r0,42r-217,0r0,-42","w":295,"k":{" ":29,"\u00a0":29,")":13,"]":13,"}":13,"*":15,"-":21,"\u00ad":21,"\u2013":21,"\u2014":21,",":42,".":42,"\u2026":42,"A":8,"\u00c0":8,"\u00c1":8,"\u00c2":8,"\u00c3":8,"\u00c4":8,"\u00c5":8,"T":25,"V":11,"W":7,"X":16,"Y":15,"\u00dd":15,"Z":4,"x":6,"\u00c6":15,"\"":67,"'":67,"\u2018":67,"\u2019":67,"\u201c":67,"\u201d":67}},"\u2018":{"d":"48,-246v31,5,21,47,-6,47v-37,0,-32,-57,-13,-73v7,-6,17,-13,25,-16r12,20v-9,3,-18,11,-18,22","w":80,"k":{" ":33,"\u00a0":33,"-":72,"\u00ad":72,"\u2013":72,"\u2014":72,",":47,".":47,"\u2026":47,"A":46,"\u00c0":46,"\u00c1":46,"\u00c2":46,"\u00c3":46,"\u00c4":46,"\u00c5":46,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"T":-7,"V":-14,"W":-14,"Y":-13,"\u00dd":-13,"Z":-7,"c":37,"e":37,"g":37,"o":37,"q":37,"\u00e7":37,"\u00e8":37,"\u00e9":37,"\u00ea":37,"\u00eb":37,"\u00f0":37,"\u00f2":37,"\u00f3":37,"\u00f4":37,"\u00f5":37,"\u00f6":37,"\u00f8":37,"t":4,"z":5,"\u00c6":72,"a":26,"m":26,"n":26,"p":26,"r":26,"s":26,"u":26,"\u00e6":26}},"\u2019":{"d":"33,-209v-12,0,-19,-10,-19,-23v0,-14,11,-23,25,-23v46,2,26,75,-1,83v-15,12,-17,-5,-24,-14v9,-4,19,-11,19,-23","w":80,"k":{" ":33,"\u00a0":33,"-":72,"\u00ad":72,"\u2013":72,"\u2014":72,",":47,".":47,"\u2026":47,"A":46,"\u00c0":46,"\u00c1":46,"\u00c2":46,"\u00c3":46,"\u00c4":46,"\u00c5":46,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"T":-7,"V":-14,"W":-14,"Y":-13,"\u00dd":-13,"Z":-7,"c":37,"e":37,"g":37,"o":37,"q":37,"\u00e7":37,"\u00e8":37,"\u00e9":37,"\u00ea":37,"\u00eb":37,"\u00f0":37,"\u00f2":37,"\u00f3":37,"\u00f4":37,"\u00f5":37,"\u00f6":37,"\u00f8":37,"t":4,"z":5,"\u00c6":72,"a":26,"m":26,"n":26,"p":26,"r":26,"s":26,"u":26,"\u00e6":26}},"\u201c":{"d":"110,-246v31,5,21,47,-6,47v-37,0,-32,-57,-13,-73v7,-6,17,-13,25,-16r12,20v-9,3,-18,11,-18,22xm48,-246v31,5,21,47,-6,47v-37,0,-32,-57,-13,-73v7,-6,17,-13,25,-16r12,20v-9,3,-18,11,-18,22","w":142,"k":{" ":33,"\u00a0":33,"-":72,"\u00ad":72,"\u2013":72,"\u2014":72,",":47,".":47,"\u2026":47,"A":46,"\u00c0":46,"\u00c1":46,"\u00c2":46,"\u00c3":46,"\u00c4":46,"\u00c5":46,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"T":-7,"V":-14,"W":-14,"Y":-13,"\u00dd":-13,"Z":-7,"c":37,"e":37,"g":37,"o":37,"q":37,"\u00e7":37,"\u00e8":37,"\u00e9":37,"\u00ea":37,"\u00eb":37,"\u00f0":37,"\u00f2":37,"\u00f3":37,"\u00f4":37,"\u00f5":37,"\u00f6":37,"\u00f8":37,"t":4,"z":5,"\u00c6":72,"a":26,"m":26,"n":26,"p":26,"r":26,"s":26,"u":26,"\u00e6":26}},"\u201d":{"d":"95,-209v-12,0,-19,-10,-19,-23v0,-14,11,-23,25,-23v46,2,26,75,-1,83v-15,12,-17,-5,-24,-14v9,-4,19,-11,19,-23xm33,-209v-12,0,-19,-10,-19,-23v0,-14,11,-23,25,-23v46,2,26,75,-1,83v-15,12,-17,-5,-24,-14v9,-4,19,-11,19,-23","w":142,"k":{" ":33,"\u00a0":33,"-":72,"\u00ad":72,"\u2013":72,"\u2014":72,",":47,".":47,"\u2026":47,"A":46,"\u00c0":46,"\u00c1":46,"\u00c2":46,"\u00c3":46,"\u00c4":46,"\u00c5":46,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"T":-7,"V":-14,"W":-14,"Y":-13,"\u00dd":-13,"Z":-7,"c":37,"e":37,"g":37,"o":37,"q":37,"\u00e7":37,"\u00e8":37,"\u00e9":37,"\u00ea":37,"\u00eb":37,"\u00f0":37,"\u00f2":37,"\u00f3":37,"\u00f4":37,"\u00f5":37,"\u00f6":37,"\u00f8":37,"t":4,"z":5,"\u00c6":72,"a":26,"m":26,"n":26,"p":26,"r":26,"s":26,"u":26,"\u00e6":26}},"\u2026":{"d":"48,4v-17,0,-29,-12,-29,-28v0,-16,11,-27,29,-27v18,0,29,10,29,27v0,17,-12,28,-29,28xm146,4v-17,0,-29,-12,-29,-28v0,-16,11,-27,29,-27v18,0,29,10,29,27v0,17,-12,28,-29,28xm244,4v-17,0,-29,-12,-29,-28v0,-16,11,-27,29,-27v18,0,29,10,29,27v0,17,-12,28,-29,28","w":291,"k":{" ":14,"\u00a0":14,"*":48,"-":42,"\u00ad":42,"\u2013":42,"\u2014":42,",":-5,".":-5,"\u2026":-5,"A":-20,"\u00c0":-20,"\u00c1":-20,"\u00c2":-20,"\u00c3":-20,"\u00c4":-20,"\u00c5":-20,"T":20,"V":22,"W":14,"X":-7,"Y":25,"\u00dd":25,"Z":-14,"t":4,"v":8,"y":8,"\u00fd":8,"\u00ff":8,"w":5,"z":-7,"\"":50,"'":50,"\u2018":50,"\u2019":50,"\u201c":50,"\u201d":50,"\u00ae":32,"\u2122":32,"a":-7,"m":-7,"n":-7,"p":-7,"r":-7,"s":-7,"u":-7,"\u00e6":-7,"\u00e0":-7,"\u00e1":-7,"\u00e2":-7,"\u00e3":-7,"\u00e4":-7,"\u00e5":-7,"\u00ec":-7,"\u00ed":-7,"\u00ee":-7,"\u00ef":-7,"\u00f1":-7,"\u00f9":-7,"\u00fa":-7,"\u00fb":-7,"\u00fc":-7}},"\u2122":{"d":"142,-212r-42,0r0,90r-47,0r0,-90r-43,0r0,-40r132,0r0,40xm288,-122v-3,-31,5,-68,4,-89v-10,26,-24,49,-37,72r-29,0v-15,-22,-25,-50,-40,-72v8,25,9,56,8,89r-40,0r0,-130r47,0v14,25,32,47,42,77v9,-29,25,-52,39,-77r47,0r0,130r-41,0","w":341}}});
