/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Copyright  2009 ParaType Ltd. All rights reserved.
 * 
 * Trademark:
 * PT Sans is a trademark of the ParaType Ltd.
 * 
 * Description:
 * PT Sans is a type family of universal use. It consists of 8 styles: regular and
 * bold weights with corresponding italics form a standard computer font family;
 * two narrow styles (regular and bold) are intended for documents that require
 * tight set; two caption styles (regular and bold) are for texts of small point
 * sizes. The design combines traditional conservative appearance with modern
 * trends of humanistic sans serif and characterized by enhanced legibility. These
 * features beside conventional use in business applications and printed stuff made
 * the fonts quite useable for direction and guide signs, schemes, screens of
 * information kiosks and other objects of urban visual communications.
 * 
 * The fonts next to standard Latin and Cyrillic character sets contain signs of
 * title languages of the national republics of Russian Federation and support the
 * most of the languages of neighboring countries. The fonts were developed and
 * released by ParaType in 2009 with financial support from Federal Agency of Print
 * and Mass Communications of Russian Federation. Design - Alexandra Korolkova with
 * assistance of Olga Umpeleva and supervision of Vladimir Yefimov.
 * 
 * Manufacturer:
 * ParaType Ltd
 * 
 * Designer:
 * A.Korolkova, O.Umpeleva, V.Yefimov
 * 
 * Vendor URL:
 * http://www.paratype.com
 */
Cufon.registerFont({"w":171,"face":{"font-family":"PT Sans Narrow","font-weight":400,"font-stretch":"condensed","units-per-em":"360","panose-1":"2 11 5 6 2 2 3 2 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-12 -313 284 83.5263","underline-thickness":"18","underline-position":"-18","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":76,"k":{"*":3,"-":4,"\u00ad":4,"\u2013":4,"\u2014":4,",":6,".":6,"\u2026":6,"T":9,"V":9,"W":6,"X":9,"Y":9,"\u00dd":9,"Z":6,"v":2,"y":2,"\u00fd":2,"\u00ff":2,"\u00c6":2,"\"":21,"'":21,"\u2018":21,"\u2019":21,"\u201c":21,"\u201d":21,"A":10,"\u00c0":10,"\u00c1":10,"\u00c2":10,"\u00c3":10,"\u00c4":10,"\u00c5":10}},"!":{"d":"36,-252r27,0r0,125r-5,63r-16,0v-8,-57,-6,-123,-6,-188xm50,4v-12,0,-18,-7,-18,-20v0,-13,6,-20,18,-20v12,0,18,7,18,20v0,13,-6,20,-18,20","w":88},"\"":{"d":"64,-252r25,0r-10,69r-15,0r0,-69xm26,-252r25,0r-10,69r-15,0r0,-69","w":102,"k":{" ":24,"\u00a0":24,"-":46,"\u00ad":46,"\u2013":46,"\u2014":46,",":36,".":36,"\u2026":36,"C":12,"G":12,"O":12,"Q":12,"\u00c7":12,"\u00d2":12,"\u00d3":12,"\u00d4":12,"\u00d5":12,"\u00d6":12,"\u00d8":12,"V":-12,"W":-12,"Y":-10,"\u00dd":-10,"c":30,"e":30,"g":30,"o":30,"q":30,"\u00e7":30,"\u00e8":30,"\u00e9":30,"\u00ea":30,"\u00eb":30,"\u00f0":30,"\u00f2":30,"\u00f3":30,"\u00f4":30,"\u00f5":30,"\u00f6":30,"\u00f8":30,"\u00c6":58,"A":36,"\u00c0":36,"\u00c1":36,"\u00c2":36,"\u00c3":36,"\u00c4":36,"\u00c5":36,"a":19,"m":19,"n":19,"p":19,"r":19,"s":19,"u":19,"\u00e6":19}},"#":{"d":"87,-81r-29,0r-12,60r-22,0r12,-60r-23,0r5,-22r22,0r10,-50r-22,0r4,-22r22,0r11,-56r22,0r-11,56r29,0r12,-56r22,0r-11,56r22,0r-5,22r-22,0r-9,50r21,0r-5,22r-20,0r-12,60r-22,0xm62,-103r30,0r10,-50r-30,0"},"$":{"d":"147,-64v0,35,-20,61,-50,67r0,33r-22,0r0,-32v-20,0,-36,-4,-48,-10r8,-25v9,6,24,10,40,10r0,-100v-25,-15,-48,-35,-48,-74v0,-33,18,-56,48,-60r0,-33r22,0r0,32v18,1,28,3,41,9r-8,23v-10,-4,-19,-7,-33,-8r0,92v25,16,49,36,50,76xm91,-21v28,-2,38,-47,20,-69v-5,-7,-12,-14,-20,-20r0,89xm81,-231v-41,7,-28,68,0,80r0,-80"},"%":{"d":"186,-257r17,11r-153,250r-17,-10xm66,-134v-35,0,-47,-24,-46,-61v0,-36,12,-61,46,-61v35,0,46,25,46,61v0,36,-11,61,-46,61xm66,-237v-21,0,-23,20,-23,42v0,26,4,41,23,41v32,0,30,-83,0,-83xm172,0v-35,0,-47,-24,-46,-61v0,-36,12,-61,46,-61v35,0,46,25,46,61v0,36,-11,61,-46,61xm172,-103v-21,0,-23,20,-23,42v0,26,4,41,23,41v32,0,30,-83,0,-83","w":229},"&":{"d":"164,-29v-30,50,-138,42,-131,-39v4,-43,25,-68,50,-87v-23,-29,-30,-101,26,-101v29,0,44,16,44,41v0,28,-19,48,-40,63v15,31,33,59,51,85v8,-12,18,-37,22,-54r21,9v-7,21,-17,46,-28,62v14,16,21,25,36,36r-16,18v-11,-6,-22,-17,-35,-33xm59,-68v0,57,71,60,90,21v-22,-26,-40,-58,-55,-89v-18,18,-35,33,-35,68xm110,-234v-31,0,-18,50,-7,66v15,-13,24,-23,26,-42v1,-13,-5,-25,-19,-24","w":236},"'":{"d":"26,-252r25,0r-10,69r-15,0r0,-69","w":65,"k":{" ":24,"\u00a0":24,"-":46,"\u00ad":46,"\u2013":46,"\u2014":46,",":36,".":36,"\u2026":36,"C":12,"G":12,"O":12,"Q":12,"\u00c7":12,"\u00d2":12,"\u00d3":12,"\u00d4":12,"\u00d5":12,"\u00d6":12,"\u00d8":12,"V":-12,"W":-12,"Y":-10,"\u00dd":-10,"c":30,"e":30,"g":30,"o":30,"q":30,"\u00e7":30,"\u00e8":30,"\u00e9":30,"\u00ea":30,"\u00eb":30,"\u00f0":30,"\u00f2":30,"\u00f3":30,"\u00f4":30,"\u00f5":30,"\u00f6":30,"\u00f8":30,"\u00c6":58,"A":36,"\u00c0":36,"\u00c1":36,"\u00c2":36,"\u00c3":36,"\u00c4":36,"\u00c5":36,"a":19,"m":19,"n":19,"p":19,"r":19,"s":19,"u":19,"\u00e6":19}},"(":{"d":"83,-247v-52,76,-53,240,0,315r-17,11v-65,-74,-63,-263,1,-335","w":83,"k":{"-":3,"\u00ad":3,"\u2013":3,"\u2014":3}},")":{"d":"2,69v52,-76,51,-240,-1,-315r17,-10v65,74,62,262,0,335","w":84},"*":{"d":"39,-253v5,9,9,20,12,32v3,-12,8,-23,14,-32r16,9v-6,11,-14,21,-22,30v11,-2,21,-5,35,-4r0,18v-13,1,-23,-2,-34,-4v8,9,16,17,21,29r-15,9v-6,-10,-11,-22,-15,-34v-3,12,-6,24,-12,33r-16,-9v5,-11,13,-20,21,-28v-10,3,-20,5,-33,4r0,-18v13,-1,24,1,34,4v-9,-9,-17,-18,-22,-30","w":104,"k":{" ":3,"\u00a0":3,"-":48,"\u00ad":48,"\u2013":48,"\u2014":48,",":72,".":72,"\u2026":72,"T":-2,"c":2,"e":2,"g":2,"o":2,"q":2,"\u00e7":2,"\u00e8":2,"\u00e9":2,"\u00ea":2,"\u00eb":2,"\u00f0":2,"\u00f2":2,"\u00f3":2,"\u00f4":2,"\u00f5":2,"\u00f6":2,"\u00f8":2,"v":-2,"y":-2,"\u00fd":-2,"\u00ff":-2,"\u00c6":12,"A":5,"\u00c0":5,"\u00c1":5,"\u00c2":5,"\u00c3":5,"\u00c4":5,"\u00c5":5}},"+":{"d":"12,-134r50,0r0,-56r25,0r0,56r50,0r0,23r-50,0r0,57r-25,0r0,-57r-50,0r0,-23","w":149},",":{"d":"32,-35v41,7,15,84,-12,88r-9,-12v12,-7,22,-19,21,-38v-11,2,-20,-6,-19,-18v0,-11,6,-22,19,-20","w":58,"k":{"J":-6," ":7,"\u00a0":7,"*":12,"-":36,"\u00ad":36,"\u2013":36,"\u2014":36,"T":5,"V":6,"W":4,"Y":6,"\u00dd":6,"v":2,"y":2,"\u00fd":2,"\u00ff":2,"\"":41,"'":41,"\u2018":41,"\u2019":41,"\u201c":41,"\u201d":41,"\u00ae":8,"\u2122":8}},"-":{"d":"17,-115r71,0r0,25r-71,0r0,-25","w":104,"k":{" ":23,"\u00a0":23,"*":4,"-":5,"\u00ad":5,"\u2013":5,"\u2014":5,",":36,".":36,"\u2026":36,"T":6,"V":3,"W":2,"X":4,"Y":4,"\u00dd":4,"\u00c6":4,"\"":39,"'":39,"\u2018":39,"\u2019":39,"\u201c":39,"\u201d":39,"A":2,"\u00c0":2,"\u00c1":2,"\u00c2":2,"\u00c3":2,"\u00c4":2,"\u00c5":2,")":3,"]":3,"}":3}},".":{"d":"32,4v-12,0,-18,-7,-18,-20v0,-13,6,-20,18,-20v12,0,18,7,18,20v0,13,-6,20,-18,20","w":55,"k":{"J":-6," ":7,"\u00a0":7,"*":12,"-":36,"\u00ad":36,"\u2013":36,"\u2014":36,"T":5,"V":6,"W":4,"Y":6,"\u00dd":6,"v":2,"y":2,"\u00fd":2,"\u00ff":2,"\"":41,"'":41,"\u2018":41,"\u2019":41,"\u201c":41,"\u201d":41,"\u00ae":8,"\u2122":8}},"\/":{"d":"96,-256r20,8r-105,298r-21,-7","w":106},"0":{"d":"86,4v-63,0,-68,-64,-68,-130v0,-65,6,-130,67,-130v63,0,68,64,68,130v0,66,-6,130,-67,130xm85,-233v-39,7,-40,50,-40,107v0,53,3,100,41,107v39,-7,40,-52,40,-107v0,-52,-2,-102,-41,-107"},"1":{"d":"39,-24r40,0r0,-175r3,-22v-10,18,-26,30,-42,42r-14,-16r65,-61r14,0r0,232r40,0r0,24r-106,0r0,-24"},"2":{"d":"29,-238v35,-32,114,-21,108,41v-7,76,-42,130,-78,176v23,-5,54,-2,82,-3r0,24r-117,0r0,-12v36,-49,77,-102,86,-180v5,-45,-49,-50,-71,-27"},"3":{"d":"144,-77v0,64,-53,98,-113,73r7,-23v35,20,80,1,80,-46v0,-42,-23,-55,-66,-51r0,-11v19,-32,31,-70,56,-95v-23,3,-50,2,-76,2r0,-24r104,0r0,10v-19,33,-33,70,-57,98v40,-10,65,24,65,67"},"4":{"d":"159,-77r-33,0r0,77r-25,0r0,-77r-89,0r0,-13r95,-166r19,0r0,155r33,0r0,24xm103,-212v-16,43,-39,80,-64,114v18,-4,40,-3,62,-3"},"5":{"d":"113,-77v0,-44,-29,-61,-72,-52r0,-123r92,0r0,25r-68,0r0,74v49,-7,74,26,74,74v0,64,-53,99,-111,76r6,-23v37,18,79,-4,79,-51"},"6":{"d":"93,-150v38,2,57,30,57,74v-1,46,-17,80,-63,80v-91,1,-68,-157,-35,-208v16,-25,38,-46,69,-52r8,21v-48,13,-71,55,-79,109v7,-12,22,-25,43,-24xm87,-19v25,1,37,-25,37,-54v0,-67,-76,-66,-76,-16v0,35,6,68,39,70"},"7":{"d":"39,0r72,-213r13,-17v-28,6,-67,2,-100,3r0,-25r124,0r0,10r-84,242r-25,0","k":{" ":15,"\u00a0":15,"-":18,"\u00ad":18,"\u2013":18,"\u2014":18,",":32,".":32,"\u2026":32,"C":3,"G":3,"O":3,"Q":3,"\u00c7":3,"\u00d2":3,"\u00d3":3,"\u00d4":3,"\u00d5":3,"\u00d6":3,"\u00d8":3,"c":5,"e":5,"g":5,"o":5,"q":5,"\u00e7":5,"\u00e8":5,"\u00e9":5,"\u00ea":5,"\u00eb":5,"\u00f0":5,"\u00f2":5,"\u00f3":5,"\u00f4":5,"\u00f5":5,"\u00f6":5,"\u00f8":5,"t":3,"\u00c6":9,"A":6,"\u00c0":6,"\u00c1":6,"\u00c2":6,"\u00c3":6,"\u00c4":6,"\u00c5":6,"a":5,"m":5,"n":5,"p":5,"r":5,"s":5,"u":5,"\u00e6":5,"\u00e0":2,"\u00e1":2,"\u00e2":2,"\u00e3":2,"\u00e4":2,"\u00e5":2,"\u00ec":2,"\u00ed":2,"\u00ee":2,"\u00ef":2,"\u00f1":2,"\u00f9":2,"\u00fa":2,"\u00fb":2,"\u00fc":2}},"8":{"d":"84,4v-39,0,-59,-24,-59,-62v0,-36,17,-55,39,-72v-47,-22,-47,-126,23,-126v34,0,55,22,54,57v-1,32,-14,49,-33,67v21,15,38,33,38,69v0,39,-23,68,-62,67xm85,-19v36,4,45,-55,23,-78v-7,-8,-17,-17,-27,-23v-35,16,-48,97,4,101xm87,-233v-43,-3,-37,68,-10,82v4,3,9,7,14,10v28,-17,39,-89,-4,-92"},"9":{"d":"121,-121v-35,42,-100,7,-100,-55v0,-47,19,-80,64,-80v91,-1,69,161,35,212v-16,25,-39,41,-70,48r-7,-21v47,-12,72,-51,78,-104xm83,-233v-25,0,-32,26,-36,54v-7,53,57,70,75,32v3,-40,-2,-86,-39,-86"},":":{"d":"45,-141v-12,0,-18,-7,-18,-20v0,-13,6,-20,18,-20v12,0,18,7,18,20v0,13,-6,20,-18,20xm45,4v-12,0,-18,-7,-18,-20v0,-13,6,-20,18,-20v12,0,18,7,18,20v0,13,-6,20,-18,20","w":74,"k":{"\/":-7}},";":{"d":"46,-35v41,7,15,84,-12,88r-9,-12v12,-7,22,-19,21,-38v-11,2,-20,-6,-19,-18v0,-11,6,-22,19,-20xm49,-141v-12,0,-18,-7,-18,-20v0,-13,6,-20,18,-20v12,0,18,7,18,20v0,13,-6,20,-18,20","w":77},"<":{"d":"13,-110r0,-10r108,-81r14,20v-31,22,-59,49,-95,66v39,14,64,42,96,63r-13,20","w":149},"=":{"d":"13,-105r123,0r0,24r-123,0r0,-24xm13,-164r123,0r0,24r-123,0r0,-24","w":149},">":{"d":"27,-32r-14,-20v32,-21,58,-49,97,-63v-37,-17,-64,-44,-96,-66r14,-20r108,81r0,10","w":149},"?":{"d":"118,-200v0,63,-52,74,-52,136r-22,0v-6,-62,43,-73,47,-132v3,-43,-48,-43,-70,-24r-10,-20v34,-27,107,-22,107,40xm57,4v-12,0,-18,-6,-18,-20v0,-14,5,-20,18,-20v12,0,18,7,18,20v0,13,-6,20,-18,20","w":128},"@":{"d":"165,-180v15,0,21,6,29,14v5,-6,8,-13,21,-11v-5,45,-16,96,-16,141v0,8,4,12,10,12v39,0,52,-47,52,-93v0,-67,-36,-104,-101,-104v-74,0,-109,56,-112,134v-3,91,64,143,150,115r6,20v-96,34,-185,-28,-180,-133v5,-93,48,-158,137,-158v79,0,123,45,123,126v0,62,-25,110,-81,116v-23,2,-27,-17,-27,-38v-12,17,-23,38,-50,38v-24,0,-38,-24,-37,-53v2,-63,20,-126,76,-126xm114,-60v-3,34,27,45,44,21v24,-21,23,-66,29,-105v-6,-7,-10,-12,-22,-12v-39,0,-47,52,-51,96","w":308},"A":{"d":"120,-71r-71,0r-21,71r-26,0r76,-256r15,0r75,256r-28,0xm56,-95r57,0v-11,-37,-21,-75,-29,-115v-6,41,-18,77,-28,115","w":170},"B":{"d":"23,-250v57,-8,125,-13,125,55v0,34,-18,50,-38,63v30,4,43,26,44,60v3,70,-66,85,-131,70r0,-248xm126,-70v0,-42,-32,-50,-76,-47r0,93v42,7,76,-4,76,-46xm120,-189v1,-38,-33,-46,-70,-39r0,88v43,4,68,-12,70,-49","w":169,"k":{"T":9}},"C":{"d":"44,-126v-5,75,43,129,104,94r7,22v-11,10,-31,14,-52,14v-69,-2,-85,-58,-88,-130v-3,-90,48,-153,137,-122r-7,25v-10,-6,-23,-8,-39,-8v-51,0,-59,50,-62,105","w":164,"k":{" ":12,"\u00a0":12,"-":22,"\u00ad":22,"\u2013":22,"\u2014":22,"C":8,"G":8,"O":8,"Q":8,"\u00c7":8,"\u00d2":8,"\u00d3":8,"\u00d4":8,"\u00d5":8,"\u00d6":8,"\u00d8":8,"T":9,"V":10,"W":3,"X":13,"Y":11,"\u00dd":11,"Z":8,"c":10,"e":10,"g":10,"o":10,"q":10,"\u00e7":10,"\u00e8":10,"\u00e9":10,"\u00ea":10,"\u00eb":10,"\u00f0":10,"\u00f2":10,"\u00f3":10,"\u00f4":10,"\u00f5":10,"\u00f6":10,"\u00f8":10,"t":10,"v":13,"y":13,"\u00fd":13,"\u00ff":13,"w":12,"x":9,"z":6,"\u00c6":33,"A":9,"\u00c0":9,"\u00c1":9,"\u00c2":9,"\u00c3":9,"\u00c4":9,"\u00c5":9,"a":5,"m":5,"n":5,"p":5,"r":5,"s":5,"u":5,"\u00e6":5}},"D":{"d":"174,-128v4,94,-48,147,-151,128r0,-252v15,-3,35,-2,54,-3v74,0,95,54,97,127xm145,-128v0,-65,-24,-115,-95,-100r0,205v74,12,95,-38,95,-105","w":189,"k":{"J":2,",":9,".":9,"\u2026":9,"T":13,"V":8,"W":6,"X":14,"Y":12,"\u00dd":12,"Z":7,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"x":9,"z":6,"\u00c6":15,"\"":12,"'":12,"\u2018":12,"\u2019":12,"\u201c":12,"\u201d":12,"A":6,"\u00c0":6,"\u00c1":6,"\u00c2":6,"\u00c3":6,"\u00c4":6,"\u00c5":6}},"E":{"d":"23,-252r112,0r0,25r-85,0r0,85r78,0r0,25r-78,0r0,92r87,0r0,25r-114,0r0,-252","w":154},"F":{"d":"23,-252r112,0r0,25r-85,0r0,89r79,0r0,25r-79,0r0,113r-27,0r0,-252","w":148},"G":{"d":"44,-126v0,73,35,126,95,96r0,-73r-46,-7r0,-16r69,0r0,111v-12,12,-36,19,-58,19v-69,0,-86,-58,-89,-130v-3,-91,51,-152,140,-122r-6,25v-65,-28,-105,22,-105,97","w":177},"H":{"d":"143,-116r-93,0r0,116r-27,0r0,-252r27,0r0,111r93,0r0,-111r27,0r0,252r-27,0r0,-116","w":192},"I":{"d":"28,-252r27,0r0,252r-27,0r0,-252","w":83},"J":{"d":"-4,-26v21,14,44,-4,37,-36r0,-190r27,0r0,195v4,49,-26,72,-69,55","w":86},"K":{"d":"63,-117r-13,0r0,117r-27,0r0,-252r27,0r0,117r13,-5r65,-112r31,0r-66,109r-12,11v35,38,57,89,87,132r-34,0","w":177,"k":{" ":9,"\u00a0":9,"-":23,"\u00ad":23,"\u2013":23,"\u2014":23,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"T":10,"V":3,"W":3,"X":9,"Y":9,"\u00dd":9,"c":14,"e":14,"g":14,"o":14,"q":14,"\u00e7":14,"\u00e8":14,"\u00e9":14,"\u00ea":14,"\u00eb":14,"\u00f0":14,"\u00f2":14,"\u00f3":14,"\u00f4":14,"\u00f5":14,"\u00f6":14,"\u00f8":14,"t":12,"v":15,"y":15,"\u00fd":15,"\u00ff":15,"w":15,"x":12,"z":8,"\u00c6":31,"A":9,"\u00c0":9,"\u00c1":9,"\u00c2":9,"\u00c3":9,"\u00c4":9,"\u00c5":9,"a":8,"m":8,"n":8,"p":8,"r":8,"s":8,"u":8,"\u00e6":8}},"L":{"d":"144,0r-121,0r0,-252r27,0r0,227r94,0r0,25","w":149,"k":{" ":13,"\u00a0":13,"*":47,"-":22,"\u00ad":22,"\u2013":22,"\u2014":22,"C":21,"G":21,"O":21,"Q":21,"\u00c7":21,"\u00d2":21,"\u00d3":21,"\u00d4":21,"\u00d5":21,"\u00d6":21,"\u00d8":21,"T":36,"V":31,"W":22,"X":32,"Y":32,"\u00dd":32,"Z":16,"c":16,"e":16,"g":16,"o":16,"q":16,"\u00e7":16,"\u00e8":16,"\u00e9":16,"\u00ea":16,"\u00eb":16,"\u00f0":16,"\u00f2":16,"\u00f3":16,"\u00f4":16,"\u00f5":16,"\u00f6":16,"\u00f8":16,"t":13,"v":28,"y":28,"\u00fd":28,"\u00ff":28,"w":20,"x":13,"z":10,"\u00c6":25,"\"":37,"'":37,"\u2018":37,"\u2019":37,"\u201c":37,"\u201d":37,"\u00ae":45,"\u2122":45,"A":24,"\u00c0":24,"\u00c1":24,"\u00c2":24,"\u00c3":24,"\u00c4":24,"\u00c5":24,"a":5,"m":5,"n":5,"p":5,"r":5,"s":5,"u":5,"\u00e6":5}},"M":{"d":"181,-204v-15,54,-41,97,-62,145r-9,0v-22,-48,-49,-91,-65,-145v6,58,3,137,4,204r-26,0r0,-252r23,0v23,51,53,96,70,153v16,-57,45,-102,67,-153r23,0r0,252r-27,0","w":229},"N":{"d":"154,4v-36,-68,-79,-129,-108,-203v4,57,3,133,3,199r-26,0r0,-256r16,0v36,67,79,127,108,201r2,0v-8,-59,-3,-131,-4,-197r26,0r0,256r-17,0","w":193},"O":{"d":"99,4v-69,0,-84,-60,-84,-130v0,-75,19,-130,84,-130v68,0,83,60,83,130v0,74,-19,130,-83,130xm99,-231v-47,0,-55,47,-55,105v0,50,7,105,55,105v47,0,55,-47,55,-105v0,-50,-7,-105,-55,-105","w":197,"k":{"J":2,",":9,".":9,"\u2026":9,"T":13,"V":8,"W":6,"X":14,"Y":12,"\u00dd":12,"Z":7,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"x":9,"z":6,"\u00c6":15,"\"":12,"'":12,"\u2018":12,"\u2019":12,"\u201c":12,"\u201d":12,"A":6,"\u00c0":6,"\u00c1":6,"\u00c2":6,"\u00c3":6,"\u00c4":6,"\u00c5":6}},"P":{"d":"152,-177v0,61,-41,91,-102,81r0,96r-27,0r0,-249v63,-17,129,-2,129,72xm124,-177v0,-44,-31,-60,-74,-51r0,107v43,9,74,-11,74,-56","w":162,"k":{" ":12,"\u00a0":12,",":38,".":38,"\u2026":38,"C":5,"G":5,"O":5,"Q":5,"\u00c7":5,"\u00d2":5,"\u00d3":5,"\u00d4":5,"\u00d5":5,"\u00d6":5,"\u00d8":5,"T":4,"X":13,"Y":7,"\u00dd":7,"Z":8,"c":10,"e":10,"g":10,"o":10,"q":10,"\u00e7":10,"\u00e8":10,"\u00e9":10,"\u00ea":10,"\u00eb":10,"\u00f0":10,"\u00f2":10,"\u00f3":10,"\u00f4":10,"\u00f5":10,"\u00f6":10,"\u00f8":10,"x":10,"z":7,"\u00c6":33,"A":19,"\u00c0":19,"\u00c1":19,"\u00c2":19,"\u00c3":19,"\u00c4":19,"\u00c5":19,"a":10,"m":10,"n":10,"p":10,"r":10,"s":10,"u":10,"\u00e6":10}},"Q":{"d":"61,18v53,-11,88,34,143,17r0,25v-54,17,-90,-25,-143,-18r0,-24xm99,4v-69,0,-84,-60,-84,-130v0,-75,19,-130,84,-130v68,0,83,60,83,130v0,74,-19,130,-83,130xm99,-231v-47,0,-55,47,-55,105v0,50,7,105,55,105v47,0,55,-47,55,-105v0,-50,-7,-105,-55,-105","w":197,"k":{"J":2,",":9,".":9,"\u2026":9,"T":13,"V":8,"W":6,"X":14,"Y":12,"\u00dd":12,"Z":7,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"x":9,"z":6,"\u00c6":15,"\"":12,"'":12,"\u2018":12,"\u2019":12,"\u201c":12,"\u201d":12,"A":6,"\u00c0":6,"\u00c1":6,"\u00c2":6,"\u00c3":6,"\u00c4":6,"\u00c5":6}},"R":{"d":"144,-186v0,39,-16,64,-45,72v30,29,41,77,63,114r-31,0r-54,-110r-27,-5r0,115r-27,0r0,-249v56,-15,121,-5,121,63xm116,-184v0,-36,-27,-55,-66,-44r0,95v42,4,66,-10,66,-51","w":172,"k":{"-":12,"\u00ad":12,"\u2013":12,"\u2014":12,"C":10,"G":10,"O":10,"Q":10,"\u00c7":10,"\u00d2":10,"\u00d3":10,"\u00d4":10,"\u00d5":10,"\u00d6":10,"\u00d8":10,"T":17,"V":14,"W":12,"X":12,"Y":16,"\u00dd":16,"Z":7,"c":14,"e":14,"g":14,"o":14,"q":14,"\u00e7":14,"\u00e8":14,"\u00e9":14,"\u00ea":14,"\u00eb":14,"\u00f0":14,"\u00f2":14,"\u00f3":14,"\u00f4":14,"\u00f5":14,"\u00f6":14,"\u00f8":14,"t":7,"v":9,"y":9,"\u00fd":9,"\u00ff":9,"w":8,"x":10,"z":7,"\u00c6":32,"\"":2,"'":2,"\u2018":2,"\u2019":2,"\u201c":2,"\u201d":2,"A":8,"\u00c0":8,"\u00c1":8,"\u00c2":8,"\u00c3":8,"\u00c4":8,"\u00c5":8}},"S":{"d":"141,-63v0,66,-79,82,-129,54r9,-24v28,18,99,21,93,-29v-9,-66,-97,-59,-97,-135v0,-62,74,-70,121,-48r-9,24v-24,-14,-91,-18,-85,23v9,64,97,59,97,135","w":154},"T":{"d":"156,-227r-62,0r0,227r-27,0r0,-227r-62,0r0,-25r151,0r0,25","w":160,"k":{"\u00ff":37,"\u00fd":37,"\u00f6":37,"\u00f5":37,"\u00f4":37,"\u00f3":37,"\u00f2":37,"\u00ef":22,"\u00ee":22,"\u00ed":22,"\u00eb":37,"\u00ea":37,"\u00e9":37,"\u00e8":37,"\u00e4":22," ":12,"\u00a0":12,"*":-2,"-":37,"\u00ad":37,"\u2013":37,"\u2014":37,",":30,".":30,"\u2026":30,"C":13,"G":13,"O":13,"Q":13,"\u00c7":13,"\u00d2":13,"\u00d3":13,"\u00d4":13,"\u00d5":13,"\u00d6":13,"\u00d8":13,"T":-7,"V":3,"W":3,"X":10,"Y":6,"\u00dd":6,"Z":10,"c":37,"e":37,"g":37,"o":37,"q":37,"\u00e7":37,"\u00f0":37,"\u00f8":37,"t":17,"v":37,"y":37,"w":37,"x":37,"z":37,"\u00c6":34,"\u00ae":-2,"\u2122":-2,"A":20,"\u00c0":20,"\u00c1":20,"\u00c2":20,"\u00c3":20,"\u00c4":20,"\u00c5":20,"a":31,"m":31,"n":31,"p":31,"r":31,"s":31,"u":31,"\u00e6":31,")":-7,"]":-7,"}":-7,"\u00e0":22,"\u00e1":22,"\u00e2":22,"\u00e3":22,"\u00e5":22,"\u00ec":22,"\u00f1":22,"\u00f9":22,"\u00fa":22,"\u00fb":22,"\u00fc":22}},"U":{"d":"96,-22v38,-1,43,-28,43,-69r0,-161r26,0r0,169v0,54,-19,86,-69,86v-51,-1,-74,-26,-73,-80r0,-175r27,0r0,161v1,39,6,70,46,69","w":187},"V":{"d":"78,-80v3,12,3,28,8,39v13,-75,36,-140,54,-211r27,0r-76,256r-14,0r-78,-256r30,0","w":166,"k":{"\u00f6":18,"\u00f5":18,"\u00ef":13,"\u00ee":13,"\u00ec":13,"\u00eb":18,"\u00e8":18,"\u00e1":13," ":9,"\u00a0":9,"*":-13,"-":15,"\u00ad":15,"\u2013":15,"\u2014":15,",":28,".":28,"\u2026":28,"C":8,"G":8,"O":8,"Q":8,"\u00c7":8,"\u00d2":8,"\u00d3":8,"\u00d4":8,"\u00d5":8,"\u00d6":8,"\u00d8":8,"T":3,"V":3,"W":3,"X":3,"Y":4,"\u00dd":4,"Z":3,"c":18,"e":18,"g":18,"o":18,"q":18,"\u00e7":18,"\u00e9":18,"\u00ea":18,"\u00f0":18,"\u00f2":18,"\u00f3":18,"\u00f4":18,"\u00f8":18,"t":2,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"w":5,"x":14,"z":12,"\u00c6":29,"\"":-12,"'":-12,"\u2018":-12,"\u2019":-12,"\u201c":-12,"\u201d":-12,"A":14,"\u00c0":14,"\u00c1":14,"\u00c2":14,"\u00c3":14,"\u00c4":14,"\u00c5":14,"a":15,"m":15,"n":15,"p":15,"r":15,"s":15,"u":15,"\u00e6":15,"\u00e0":13,"\u00e2":13,"\u00e3":13,"\u00e4":13,"\u00e5":13,"\u00ed":13,"\u00f1":13,"\u00f9":13,"\u00fa":13,"\u00fb":13,"\u00fc":13}},"W":{"d":"31,-252v13,70,33,133,39,209v8,-73,30,-140,45,-209r16,0v16,69,36,133,45,209v8,-74,25,-139,37,-209r27,0r-56,256r-17,0v-15,-69,-36,-130,-45,-205v-11,70,-30,137,-46,205r-17,0r-57,-256r29,0","w":241,"k":{"\u00f6":13,"\u00ef":9,"\u00ec":9,"\u00eb":13," ":7,"\u00a0":7,"*":-13,"-":8,"\u00ad":8,"\u2013":8,"\u2014":8,",":22,".":22,"\u2026":22,"C":6,"G":6,"O":6,"Q":6,"\u00c7":6,"\u00d2":6,"\u00d3":6,"\u00d4":6,"\u00d5":6,"\u00d6":6,"\u00d8":6,"T":3,"V":3,"W":3,"X":3,"Y":4,"\u00dd":4,"Z":3,"c":13,"e":13,"g":13,"o":13,"q":13,"\u00e7":13,"\u00e8":13,"\u00e9":13,"\u00ea":13,"\u00f0":13,"\u00f2":13,"\u00f3":13,"\u00f4":13,"\u00f5":13,"\u00f8":13,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":5,"x":12,"z":11,"\u00c6":25,"\"":-12,"'":-12,"\u2018":-12,"\u2019":-12,"\u201c":-12,"\u201d":-12,"\u00ae":-2,"\u2122":-2,"A":9,"\u00c0":9,"\u00c1":9,"\u00c2":9,"\u00c3":9,"\u00c4":9,"\u00c5":9,"a":12,"m":12,"n":12,"p":12,"r":12,"s":12,"u":12,"\u00e6":12,"\u00e0":9,"\u00e1":9,"\u00e2":9,"\u00e3":9,"\u00e4":9,"\u00e5":9,"\u00ed":9,"\u00ee":9,"\u00f1":9,"\u00f9":9,"\u00fa":9,"\u00fb":9,"\u00fc":9}},"X":{"d":"73,-128r-60,-124r32,0v15,36,34,68,46,107v13,-39,33,-71,49,-107r30,0r-63,121r66,131r-32,0r-52,-113v-12,43,-35,75,-52,113r-30,0","w":180,"k":{" ":9,"\u00a0":9,"-":23,"\u00ad":23,"\u2013":23,"\u2014":23,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"T":10,"V":3,"W":3,"X":9,"Y":9,"\u00dd":9,"c":14,"e":14,"g":14,"o":14,"q":14,"\u00e7":14,"\u00e8":14,"\u00e9":14,"\u00ea":14,"\u00eb":14,"\u00f0":14,"\u00f2":14,"\u00f3":14,"\u00f4":14,"\u00f5":14,"\u00f6":14,"\u00f8":14,"t":12,"v":15,"y":15,"\u00fd":15,"\u00ff":15,"w":15,"x":12,"z":8,"\u00c6":31,"A":9,"\u00c0":9,"\u00c1":9,"\u00c2":9,"\u00c3":9,"\u00c4":9,"\u00c5":9,"a":8,"m":8,"n":8,"p":8,"r":8,"s":8,"u":8,"\u00e6":8}},"Y":{"d":"69,-100r-67,-152r31,0v17,44,39,83,51,132v11,-50,33,-87,49,-132r29,0r-66,152r0,100r-27,0r0,-100","w":163,"k":{"\u00ff":14,"\u00f6":26,"\u00f5":26,"\u00f2":26,"\u00ef":18,"\u00ee":18,"\u00ec":18,"\u00eb":26,"\u00e8":26,"\u00e5":18,"\u00e2":18,"\u00e1":18," ":7,"\u00a0":7,"*":-7,"-":18,"\u00ad":18,"\u2013":18,"\u2014":18,",":32,".":32,"\u2026":32,"C":12,"G":12,"O":12,"Q":12,"\u00c7":12,"\u00d2":12,"\u00d3":12,"\u00d4":12,"\u00d5":12,"\u00d6":12,"\u00d8":12,"T":6,"V":4,"W":3,"X":9,"Y":4,"\u00dd":4,"Z":9,"c":26,"e":26,"g":26,"o":26,"q":26,"\u00e7":26,"\u00e9":26,"\u00ea":26,"\u00f0":26,"\u00f3":26,"\u00f4":26,"\u00f8":26,"t":12,"v":14,"y":14,"\u00fd":14,"w":12,"x":17,"z":19,"\u00c6":29,"\"":-10,"'":-10,"\u2018":-10,"\u2019":-10,"\u201c":-10,"\u201d":-10,"\u00ae":-2,"\u2122":-2,"A":21,"\u00c0":21,"\u00c1":21,"\u00c2":21,"\u00c3":21,"\u00c4":21,"\u00c5":21,"a":21,"m":21,"n":21,"p":21,"r":21,"s":21,"u":21,"\u00e6":21,"\u00e0":18,"\u00e3":18,"\u00e4":18,"\u00ed":18,"\u00f1":18,"\u00f9":18,"\u00fa":18,"\u00fb":18,"\u00fc":18}},"Z":{"d":"10,-25r101,-188r11,-14r-112,0r0,-25r138,0r0,25r-101,189r-11,13r112,0r0,25r-138,0r0,-25","w":158,"k":{" ":11,"\u00a0":11,"-":24,"\u00ad":24,"\u2013":24,"\u2014":24,"C":7,"G":7,"O":7,"Q":7,"\u00c7":7,"\u00d2":7,"\u00d3":7,"\u00d4":7,"\u00d5":7,"\u00d6":7,"\u00d8":7,"T":7,"V":3,"W":3,"X":8,"Y":9,"\u00dd":9,"Z":6,"c":14,"e":14,"g":14,"o":14,"q":14,"\u00e7":14,"\u00e8":14,"\u00e9":14,"\u00ea":14,"\u00eb":14,"\u00f0":14,"\u00f2":14,"\u00f3":14,"\u00f4":14,"\u00f5":14,"\u00f6":14,"\u00f8":14,"t":4,"v":8,"y":8,"\u00fd":8,"\u00ff":8,"w":8,"x":5,"z":7,"\u00c6":30,"A":6,"\u00c0":6,"\u00c1":6,"\u00c2":6,"\u00c3":6,"\u00c4":6,"\u00c5":6,"a":6,"m":6,"n":6,"p":6,"r":6,"s":6,"u":6,"\u00e6":6}},"[":{"d":"23,-252r56,0r0,23r-30,0r0,288r30,0r0,24r-56,0r0,-335","w":89,"k":{"-":3,"\u00ad":3,"\u2013":3,"\u2014":3}},"\\":{"d":"119,42r-22,8r-107,-298r22,-8","w":113},"]":{"d":"67,83r-57,0r0,-24r31,0r0,-288r-31,0r0,-23r57,0r0,335","w":89},"^":{"d":"69,-256r11,0r50,99r-27,0v-11,-23,-24,-44,-29,-73v-8,28,-23,49,-35,73r-25,0","w":148},"_":{"d":"0,50r120,0r0,24r-120,0r0,-24","w":120},"`":{"d":"70,-206r-15,0v-10,-19,-28,-29,-33,-53r29,0","w":91},"a":{"d":"98,-122v8,-48,-45,-40,-70,-27r-9,-20v36,-22,115,-22,104,41v2,43,-5,91,3,129r-20,0v-3,-7,-3,-17,-7,-22v-17,38,-93,28,-89,-27v3,-46,37,-57,87,-55v1,-7,1,-13,1,-19xm37,-51v0,41,61,35,61,7r0,-38v-29,-2,-61,1,-61,31","w":144,"k":{"\u201d":4,"\u201c":4,"\u2019":4,"\u2018":4,"T":35,"'":4,"\"":4}},"b":{"d":"72,3v-19,1,-39,-6,-51,-12r0,-243r26,0r1,86v10,-12,23,-18,39,-18v44,2,56,38,56,91v-1,57,-20,94,-71,96xm81,-161v-53,0,-29,84,-34,135v43,19,73,-14,69,-67v-2,-33,-4,-68,-35,-68","w":156,"k":{"f":4,"*":2,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":3,"x":7,"z":4,"\"":17,"'":17,"\u2018":17,"\u2019":17,"\u201c":17,"\u201d":17}},"c":{"d":"82,-19v13,0,25,-5,31,-11r8,21v-11,9,-27,13,-45,13v-52,0,-60,-44,-63,-94v-5,-71,43,-114,105,-85r-7,22v-44,-24,-75,8,-71,63v3,37,8,68,42,71","w":128,"k":{"y":4," ":7,"\u00a0":7,"-":13,"\u00ad":13,"\u2013":13,"\u2014":13,"c":6,"e":6,"g":6,"o":6,"q":6,"\u00e7":6,"\u00e8":6,"\u00e9":6,"\u00ea":6,"\u00eb":6,"\u00f0":6,"\u00f2":6,"\u00f3":6,"\u00f4":6,"\u00f5":6,"\u00f6":6,"\u00f8":6,"x":4,"z":4,"\"":2,"'":2,"\u2018":2,"\u2019":2,"\u201c":2,"\u201d":2}},"d":{"d":"13,-90v-3,-65,37,-108,96,-88r0,-74r26,0r0,223v0,10,2,20,3,30r-18,0v-3,-7,-3,-17,-7,-22v-6,13,-22,26,-42,25v-47,-2,-56,-40,-58,-94xm40,-89v3,34,4,70,36,70v49,0,30,-85,33,-133v-39,-24,-74,11,-69,63","w":155},"e":{"d":"86,-19v12,-1,27,-6,34,-12r9,19v-11,10,-30,16,-50,16v-51,-1,-66,-42,-66,-94v0,-54,17,-92,65,-94v52,-3,60,45,54,97r-92,0v1,37,10,67,46,68xm109,-109v7,-44,-33,-67,-57,-39v-6,8,-10,21,-11,39r68,0","w":148,"k":{"*":2,"c":3,"e":3,"g":3,"o":3,"q":3,"\u00e7":3,"\u00e8":3,"\u00e9":3,"\u00ea":3,"\u00eb":3,"\u00f0":3,"\u00f2":3,"\u00f3":3,"\u00f4":3,"\u00f5":3,"\u00f6":3,"\u00f8":3,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"w":3,"x":6,"z":3,"\"":5,"'":5,"\u2018":5,"\u2019":5,"\u201c":5,"\u201d":5,"\u00ae":2,"\u2122":2}},"f":{"d":"96,-226v-30,-16,-49,8,-42,46r37,0r0,23r-37,0r0,157r-26,0r0,-157r-22,0r0,-23r22,0v-8,-59,24,-88,75,-68","w":92,"k":{"\u00ef":-17,"\u00ee":-7,"\u00ec":-14,"}":-17,"]":-17,"*":-3,",":2,".":2,"\u2026":2,"c":3,"e":3,"g":3,"o":3,"q":3,"\u00e7":3,"\u00e8":3,"\u00e9":3,"\u00ea":3,"\u00eb":3,"\u00f0":3,"\u00f2":3,"\u00f3":3,"\u00f4":3,"\u00f5":3,"\u00f6":3,"\u00f8":3,"t":4,"\"":-3,"'":-3,"\u2018":-3,"\u2019":-3,"\u201c":-3,"\u201d":-3,"\u00ae":-4,"\u2122":-4,")":-17}},"g":{"d":"84,-183v21,0,38,4,51,11r0,180v7,64,-59,82,-109,58r7,-22v11,4,22,9,38,9v38,0,40,-31,37,-67v-8,12,-19,18,-38,18v-46,0,-57,-39,-57,-93v0,-56,20,-93,71,-94xm76,-19v53,0,27,-85,33,-135v-42,-19,-73,12,-69,64v2,34,4,71,36,71","w":155},"h":{"d":"93,-184v74,1,37,116,46,184r-26,0r0,-109v-1,-29,-2,-51,-29,-52v-18,0,-37,16,-37,32r0,129r-26,0r0,-252r26,0r1,89v10,-12,23,-21,45,-21","w":158},"i":{"d":"26,-180r25,0r0,180r-25,0r0,-180xm39,-216v-11,0,-18,-7,-18,-19v0,-11,7,-20,18,-19v11,0,18,7,18,19v0,12,-7,19,-18,19","w":78},"j":{"d":"1,52v27,0,25,-27,25,-53r0,-179r26,0r0,190v0,44,-10,70,-51,66r0,-24xm39,-216v-11,0,-18,-7,-18,-19v0,-11,7,-20,18,-19v11,0,18,7,18,19v0,12,-7,19,-18,19","w":77},"k":{"d":"60,-81r-13,0r0,81r-26,0r0,-252r26,0r0,153r12,-5r42,-76r30,0v-19,28,-29,63,-55,84v28,24,40,64,61,96r-31,0","w":139,"k":{"\u00f8":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00f0":7,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"\u00e7":7,"q":7,"o":7,"g":7,"e":7,"c":7," ":9,"\u00a0":9,"-":13,"\u00ad":13,"\u2013":13,"\u2014":13,"x":4}},"l":{"d":"82,-3v-24,14,-59,7,-59,-31r0,-218r26,0r0,209v-2,23,12,29,31,20","w":83},"m":{"d":"44,-161v14,-26,75,-35,82,4v8,-14,24,-27,45,-27v74,1,36,117,45,184r-26,0r0,-114v-2,-27,0,-47,-25,-47v-58,0,-26,105,-34,161r-26,0r0,-107v1,-28,2,-54,-25,-54v-56,0,-26,104,-33,161r-26,0r0,-180r19,0","w":234},"n":{"d":"92,-184v75,1,39,116,47,184r-26,0r0,-110v-1,-30,-2,-50,-28,-51v-21,0,-32,15,-38,30r0,131r-26,0r0,-180r19,0v2,6,2,15,6,19v9,-12,24,-24,46,-23","w":158,"k":{"T":36}},"o":{"d":"78,4v-51,0,-65,-38,-65,-94v0,-56,16,-94,65,-94v51,0,64,38,64,94v0,57,-16,94,-64,94xm78,-161v-32,0,-38,31,-38,71v0,36,4,71,38,71v32,0,37,-30,37,-71v0,-35,-4,-71,-37,-71","w":155,"k":{"f":4,"*":2,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":3,"x":7,"z":4,"\"":17,"'":17,"\u2018":17,"\u2019":17,"\u201c":17,"\u201d":17}},"p":{"d":"144,-94v3,63,-35,116,-97,92r0,74r-26,0r0,-252r19,0v2,6,1,15,5,19v9,-16,23,-23,42,-23v46,2,55,36,57,90xm75,-19v53,-1,61,-138,6,-142v-49,-4,-31,84,-34,133v7,5,15,9,28,9","w":156,"k":{"f":4,"*":2,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":3,"x":7,"z":4,"\"":17,"'":17,"\u2018":17,"\u2019":17,"\u201c":17,"\u201d":17}},"q":{"d":"13,-89v-5,-78,60,-114,122,-83r0,244r-26,0v-2,-28,4,-63,-2,-87v-7,12,-18,19,-37,19v-46,0,-54,-39,-57,-93xm75,-19v53,0,29,-85,34,-135v-42,-20,-73,12,-69,64v3,34,3,71,35,71","w":155},"r":{"d":"92,-154v-22,-9,-45,2,-45,22r0,132r-26,0r0,-180r19,0v2,6,1,15,5,19v7,-18,28,-27,52,-19","w":98,"k":{",":14,".":14,"\u2026":14,"t":-9}},"s":{"d":"110,-45v0,51,-64,59,-100,38r8,-23v17,13,68,20,66,-14v-4,-50,-69,-38,-69,-94v0,-48,57,-57,92,-36r-7,21v-16,-9,-64,-17,-59,14v7,45,69,37,69,94","w":121},"t":{"d":"96,-5v-31,18,-71,11,-71,-41r0,-111r-22,0r0,-23r22,0r0,-36r26,-8r0,44r39,0r0,23r-39,0r0,108v-5,31,21,35,40,24","w":99,"k":{"-":8,"\u00ad":8,"\u2013":8,"\u2014":8,"c":3,"e":3,"g":3,"o":3,"q":3,"\u00e7":3,"\u00e8":3,"\u00e9":3,"\u00ea":3,"\u00eb":3,"\u00f0":3,"\u00f2":3,"\u00f3":3,"\u00f4":3,"\u00f5":3,"\u00f6":3,"\u00f8":3,"v":2,"y":2,"\u00fd":2,"\u00ff":2,"x":4}},"u":{"d":"66,4v-75,-1,-38,-116,-47,-184r26,0r0,110v0,30,1,51,26,51v60,0,32,-101,38,-161r26,0r0,129v0,17,2,36,3,51r-18,0v-3,-8,-3,-19,-8,-25v-7,15,-22,29,-46,29","w":156},"v":{"d":"31,-180v14,47,32,89,41,141v9,-49,25,-95,39,-141r27,0r-61,184r-13,0r-63,-184r30,0","w":139,"k":{" ":10,"\u00a0":10,"*":-2,",":21,".":21,"\u2026":21,"v":-4,"y":-4,"\u00fd":-4,"\u00ff":-4,"w":-3,"x":3,"z":2}},"w":{"d":"117,-180r40,140v6,-51,19,-94,29,-140r25,0r-48,184r-15,0v-13,-50,-33,-93,-41,-148v-10,51,-27,99,-41,148r-15,0r-49,-184r28,0v11,46,26,89,32,140v9,-50,24,-94,36,-140r19,0","w":212,"k":{" ":7,"\u00a0":7,",":18,".":18,"\u2026":18,"c":3,"e":3,"g":3,"o":3,"q":3,"\u00e7":3,"\u00e8":3,"\u00e9":3,"\u00ea":3,"\u00eb":3,"\u00f0":3,"\u00f2":3,"\u00f3":3,"\u00f4":3,"\u00f5":3,"\u00f6":3,"\u00f8":3,"v":-3,"y":-3,"\u00fd":-3,"\u00ff":-3,"w":-2,"x":4,"z":4}},"x":{"d":"58,-92r-48,-88r31,0v12,24,26,44,34,72v9,-27,23,-48,35,-72r29,0r-48,86r50,94r-29,0v-13,-26,-28,-49,-38,-78v-10,29,-26,52,-39,78r-28,0","w":148,"k":{" ":9,"\u00a0":9,"-":13,"\u00ad":13,"\u2013":13,"\u2014":13,"c":7,"e":7,"g":7,"o":7,"q":7,"\u00e7":7,"\u00e8":7,"\u00e9":7,"\u00ea":7,"\u00eb":7,"\u00f0":7,"\u00f2":7,"\u00f3":7,"\u00f4":7,"\u00f5":7,"\u00f6":7,"\u00f8":7,"x":4}},"y":{"d":"75,-29v8,-53,22,-101,33,-151r26,0r-53,198v-9,29,-20,66,-59,53r4,-25v25,6,30,-22,35,-46r-58,-180r29,0","w":135,"k":{" ":10,"\u00a0":10,"*":-2,",":21,".":21,"\u2026":21,"v":-4,"y":-4,"\u00fd":-4,"\u00ff":-4,"w":-3,"x":3,"z":2}},"z":{"d":"12,-23v27,-44,48,-94,79,-134r-79,0r0,-23r105,0r0,23v-27,44,-49,94,-80,134r80,0r0,23r-105,0r0,-23","w":129,"k":{" ":9,"\u00a0":9,"-":12,"\u00ad":12,"\u2013":12,"\u2014":12,"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"v":2,"y":2,"\u00fd":2,"\u00ff":2}},"{":{"d":"64,39v0,19,11,21,30,20r0,24v-34,2,-55,0,-55,-37v0,-41,18,-116,-24,-119r0,-23v42,-4,18,-79,24,-120v-3,-33,21,-39,55,-36r0,23v-19,-1,-30,1,-30,21v0,42,14,111,-20,122r0,2v34,12,20,80,20,123","w":101,"k":{"-":3,"\u00ad":3,"\u2013":3,"\u2014":3}},"|":{"d":"23,-252r22,0r0,299r-22,0r0,-299","w":68},"}":{"d":"86,-73v-41,4,-17,79,-23,119v1,36,-21,39,-55,37r0,-24v18,1,29,0,29,-20v0,-45,-11,-109,20,-125v-34,-11,-15,-80,-20,-122v2,-21,-10,-22,-29,-21r0,-23v34,-3,55,4,55,36v0,42,-17,114,23,120r0,23","w":101},"~":{"d":"50,-125v-12,0,-21,7,-30,16r-12,-21v14,-12,23,-21,43,-21v30,0,54,35,78,7r12,22v-13,9,-21,16,-37,17v-24,0,-31,-20,-54,-20","w":149},"\u00a0":{"w":76,"k":{"*":3,"-":4,"\u00ad":4,"\u2013":4,"\u2014":4,",":6,".":6,"\u2026":6,"T":9,"V":9,"W":6,"X":9,"Y":9,"\u00dd":9,"Z":6,"v":2,"y":2,"\u00fd":2,"\u00ff":2,"\u00c6":2,"\"":21,"'":21,"\u2018":21,"\u2019":21,"\u201c":21,"\u201d":21,"A":10,"\u00c0":10,"\u00c1":10,"\u00c2":10,"\u00c3":10,"\u00c4":10,"\u00c5":10}},"\u00a1":{"d":"25,73r27,-0r0,-125r-5,-63r-16,-0v-8,57,-6,123,-6,188xm39,-183v-12,0,-18,7,-18,20v0,13,6,20,18,20v12,-0,18,-7,18,-20v0,-13,-6,-20,-18,-20","w":88},"\u00a2":{"d":"85,4v-75,-8,-71,-180,0,-187r0,-33r23,0r0,32v12,1,23,4,31,9r-7,22v-8,-4,-15,-7,-26,-8r0,142v11,-1,22,-6,29,-11r7,20v-7,8,-21,11,-34,13r0,33r-23,0r0,-32xm89,-159v-44,10,-40,127,0,138r0,-138"},"\u00a3":{"d":"19,-25v40,-1,41,-57,29,-89r-29,0r0,-23r20,0v-17,-47,-10,-119,52,-119v21,0,39,4,53,10r-9,24v-27,-16,-77,-14,-77,35v0,20,5,35,10,50r45,0r0,23r-37,0v13,34,4,80,-20,94v25,-8,62,-4,94,-5r0,25r-131,0r0,-25"},"\u00a4":{"d":"41,-96v-14,-17,-13,-50,0,-65v-15,-8,-24,-21,-36,-32r16,-15v11,11,24,20,32,35v16,-15,50,-13,65,0v8,-15,21,-24,32,-35r15,15v-11,11,-20,24,-35,32v14,17,13,49,0,65v15,8,24,21,35,32r-15,15v-11,-11,-24,-20,-32,-35v-17,13,-48,14,-65,0v-8,15,-21,24,-32,35r-16,-15v12,-11,21,-24,36,-32xm85,-162v-19,0,-32,15,-32,33v0,20,13,33,32,34v19,0,33,-14,33,-34v0,-19,-13,-33,-33,-33"},"\u00a5":{"d":"36,-117r29,0r-60,-135r32,0v16,44,39,83,50,132v13,-46,33,-88,49,-132r30,0r-59,135r28,0r0,21r-36,0r0,23r36,0r0,21r-36,0r0,52r-27,0r0,-52r-36,0r0,-21r36,0r0,-23r-36,0r0,-21"},"\u00a6":{"d":"23,-77r22,0r0,124r-22,0r0,-124xm45,-129r-22,0r0,-123r22,0r0,123","w":68},"\u00a7":{"d":"93,-41v-12,-41,-80,-30,-77,-86v1,-22,11,-41,30,-47v-31,-20,-22,-87,29,-82v18,2,33,4,45,9r-6,23v-17,-9,-61,-18,-61,12v10,44,80,30,77,87v-2,21,-9,43,-30,47v32,20,21,82,-30,82v-20,0,-34,-3,-45,-10r7,-22v17,10,63,17,61,-13xm83,-88v17,-9,31,-46,8,-60v-9,-6,-17,-9,-28,-15v-20,7,-29,45,-8,60v9,6,17,9,28,15","w":145},"\u00a8":{"d":"37,-218v-9,0,-15,-7,-15,-17v0,-11,5,-18,15,-18v10,0,16,7,16,18v0,9,-7,17,-16,17xm94,-218v-9,0,-15,-7,-15,-17v0,-11,5,-18,15,-18v10,0,17,7,16,18v0,10,-6,17,-16,17","w":131},"\u00a9":{"d":"125,1v-68,0,-107,-38,-107,-106v0,-68,41,-107,107,-107v66,0,107,41,107,107v0,66,-41,106,-107,106xm125,-192v-53,0,-85,31,-85,87v1,55,31,86,85,86v54,0,84,-31,85,-86v0,-56,-32,-87,-85,-87xm150,-135v-23,-13,-55,-5,-50,30v-3,35,30,42,54,29r7,20v-38,20,-94,1,-87,-49v-4,-48,44,-72,84,-50","w":249},"\u00aa":{"d":"77,-209v9,-38,-35,-27,-52,-19r-6,-17v25,-13,85,-21,80,26v-3,29,-3,57,1,82r-18,0v-2,-5,-1,-12,-5,-15v-12,27,-66,20,-63,-18v3,-33,28,-40,63,-39xm77,-191v-34,-11,-57,29,-25,36v20,0,28,-13,25,-36","w":114},"\u00ab":{"d":"64,-93r46,-82r17,12v-14,23,-23,51,-42,69v20,17,30,44,44,67r-17,13xm10,-93r47,-83r18,12v-14,24,-23,52,-43,70v20,18,30,45,45,68r-18,12","w":138},"\u00ac":{"d":"13,-141r123,0r0,69r-23,0r0,-44r-100,0r0,-25","w":149},"\u00ad":{"d":"17,-115r71,0r0,25r-71,0r0,-25","w":104,"k":{" ":23,"\u00a0":23,"*":4,"-":5,"\u00ad":5,"\u2013":5,"\u2014":5,",":36,".":36,"\u2026":36,"T":6,"V":3,"W":2,"X":4,"Y":4,"\u00dd":4,"\u00c6":4,"\"":39,"'":39,"\u2018":39,"\u2019":39,"\u201c":39,"\u201d":39,"A":2,"\u00c0":2,"\u00c1":2,"\u00c2":2,"\u00c3":2,"\u00c4":2,"\u00c5":2,")":3,"]":3,"}":3}},"\u00ae":{"d":"106,-96v-50,0,-80,-29,-80,-80v0,-52,31,-81,80,-81v49,0,81,29,81,81v0,50,-30,80,-81,80xm106,-239v-40,0,-61,23,-61,63v0,40,23,62,61,62v39,0,61,-21,61,-62v1,-41,-23,-63,-61,-63xm105,-219v32,-6,43,43,10,45v16,7,20,25,31,37r-19,0v-11,-13,-16,-32,-36,-36r0,36r-16,0r0,-79v6,-1,22,-3,30,-3xm120,-194v2,-10,-17,-13,-29,-10r0,22v14,1,30,-1,29,-12","w":212},"\u00af":{"d":"22,-231r87,0r0,21r-87,0r0,-21","w":130},"\u00b0":{"d":"64,-155v-27,0,-42,-22,-42,-51v0,-28,16,-50,42,-50v26,0,43,21,43,50v0,29,-16,51,-43,51xm64,-237v-28,1,-28,62,0,63v30,0,29,-63,0,-63","w":123},"\u00b1":{"d":"13,-169r50,0r0,-56r24,0r0,56r50,0r0,24r-50,0r0,38r-24,0r0,-38r-50,0r0,-24xm13,-89r124,0r0,24r-124,0r0,-24","w":149},"\u00b2":{"d":"18,-279v25,-21,82,-15,77,29v-5,45,-26,74,-52,97v14,-7,36,-5,57,-5r0,21r-86,0r0,-11v22,-26,54,-55,58,-99v2,-27,-33,-25,-47,-13","w":115},"\u00b3":{"d":"24,-161v18,12,57,7,53,-22v1,-23,-18,-28,-43,-26v6,-27,23,-43,38,-61v-14,4,-34,3,-52,3r0,-21r75,0v-1,28,-20,37,-29,57v-2,3,-7,3,-8,7v27,-6,42,15,42,41v0,42,-45,60,-81,42","w":115},"\u00b4":{"d":"39,-259r28,0v-4,24,-21,34,-30,53r-15,0","w":88},"\u00b5":{"d":"120,-22v-9,25,-64,39,-79,10r-2,0v6,24,7,53,6,84r-26,0r0,-252r26,0r0,109v0,30,6,52,32,52v22,0,35,-15,40,-33r0,-128r26,0v2,60,-5,127,4,180r-18,0","w":162},"\u03bc":{"d":"120,-22v-9,25,-64,39,-79,10r-2,0v6,24,7,53,6,84r-26,0r0,-252r26,0r0,109v0,30,6,52,32,52v22,0,35,-15,40,-33r0,-128r26,0v2,60,-5,127,4,180r-18,0","w":162},"\u00b6":{"d":"100,-252r22,0r0,299r-22,0r0,-299xm53,-112v-65,-10,-56,-155,22,-140r0,299r-22,0r0,-159","w":145},"\u00b7":{"d":"38,-86v-12,0,-18,-7,-18,-20v0,-13,6,-20,18,-20v12,0,18,7,18,20v0,13,-6,20,-18,20","w":76},"\u00b8":{"d":"24,59v15,1,24,0,25,-13v0,-7,-8,-12,-25,-14r14,-32r18,0r-7,15v29,4,30,42,10,54v-11,5,-22,7,-37,4","w":94},"\u00b9":{"d":"22,-157r30,0v1,-35,-2,-74,2,-106v-7,11,-19,17,-30,25r-9,-15r45,-38r15,0r0,134r27,0r0,20r-80,0r0,-20","w":115},"\u00ba":{"d":"59,-134v-35,0,-47,-24,-46,-61v0,-36,12,-61,46,-61v35,0,46,25,46,61v0,36,-11,61,-46,61xm59,-237v-21,0,-23,20,-23,42v0,26,4,41,23,41v32,0,30,-83,0,-83","w":117},"\u00bb":{"d":"75,-96r-46,82r-17,-12v14,-24,23,-51,42,-70v-20,-17,-30,-44,-44,-67r17,-12xm129,-96r-47,82r-18,-12v14,-24,24,-51,43,-70v-20,-18,-30,-45,-45,-68r18,-12","w":138},"\u00bc":{"d":"49,-101r2,-126v-7,11,-19,17,-29,25r-10,-16r45,-37r15,0r0,154r-23,0xm229,-35r-23,0r0,35r-22,0r0,-35r-60,0r0,-12r65,-108r17,0r0,100r23,0r0,20xm184,-55v-1,-21,1,-47,1,-64v-10,25,-21,48,-38,66v11,-2,24,-2,37,-2xm182,-257r17,10r-138,251r-18,-10","w":245},"\u00bd":{"d":"49,-101r2,-126v-7,11,-19,17,-29,25r-10,-16r45,-37r15,0r0,154r-23,0xm153,-142v25,-21,81,-15,77,29v-4,46,-26,73,-51,97v14,-7,36,-5,57,-5r0,21r-86,0r0,-12v23,-25,54,-55,58,-98v2,-27,-35,-26,-47,-13xm182,-257r17,10r-138,251r-18,-10","w":252},"\u00be":{"d":"239,-35r-23,0r0,35r-22,0r0,-35r-60,0r0,-12r65,-108r17,0r0,100r23,0r0,20xm194,-55v-1,-21,1,-47,1,-64v-10,25,-21,48,-38,66v11,-2,24,-2,37,-2xm22,-125v18,12,57,7,53,-22v1,-23,-18,-28,-43,-26v6,-27,22,-44,38,-61v-14,4,-34,3,-52,3r0,-21r75,0v-1,28,-20,37,-29,57v-2,3,-7,3,-8,7v27,-6,42,15,42,41v0,41,-45,60,-81,42xm192,-257r18,10r-139,251r-18,-10","w":255},"\u00bf":{"d":"11,20v0,-63,52,-74,52,-136r22,-0v6,62,-43,73,-47,132v-3,43,48,43,70,24r10,20v-34,27,-107,22,-107,-40xm72,-184v12,0,18,6,18,20v0,14,-5,20,-18,20v-12,-0,-18,-7,-18,-20v0,-13,6,-20,18,-20","w":128},"\u00c0":{"d":"93,-271r-24,0r-45,-35r0,-7r35,0xm120,-71r-71,0r-21,71r-26,0r76,-256r15,0r75,256r-28,0xm56,-95r57,0v-11,-37,-21,-75,-29,-115v-6,41,-18,77,-28,115","w":170},"\u00c1":{"d":"111,-313r36,0r0,7r-48,35r-22,0xm120,-71r-71,0r-21,71r-26,0r76,-256r15,0r75,256r-28,0xm56,-95r57,0v-11,-37,-21,-75,-29,-115v-6,41,-18,77,-28,115","w":170},"\u00c2":{"d":"77,-313r18,0r36,37r0,7r-23,0v-8,-9,-18,-17,-23,-30v-8,18,-18,34,-47,30r0,-8xm120,-71r-71,0r-21,71r-26,0r76,-256r15,0r75,256r-28,0xm56,-95r57,0v-11,-37,-21,-75,-29,-115v-6,41,-18,77,-28,115","w":170},"\u00c3":{"d":"71,-302v20,0,40,21,55,4r9,13v-20,40,-68,-12,-90,17r-9,-13v11,-12,18,-21,35,-21xm120,-71r-71,0r-21,71r-26,0r76,-256r15,0r75,256r-28,0xm56,-95r57,0v-11,-37,-21,-75,-29,-115v-6,41,-18,77,-28,115","w":170},"\u00c4":{"d":"57,-269v-10,0,-17,-6,-17,-17v0,-11,7,-17,17,-17v10,0,16,7,16,17v0,10,-6,17,-16,17xm113,-269v-10,0,-16,-7,-16,-17v0,-10,6,-17,16,-17v10,0,17,6,17,17v0,11,-7,17,-17,17xm120,-71r-71,0r-21,71r-26,0r76,-256r15,0r75,256r-28,0xm56,-95r57,0v-11,-37,-21,-75,-29,-115v-6,41,-18,77,-28,115","w":170},"\u00c5":{"d":"75,-247v-31,-6,-29,-65,11,-60v38,-5,42,55,9,60r73,247r-28,0r-20,-71r-71,0r-21,71r-26,0xm56,-95r57,0v-11,-37,-21,-75,-29,-115v-6,41,-18,77,-28,115xm73,-276v0,8,4,15,13,14v9,0,13,-4,13,-14v0,-10,-4,-16,-13,-16v-9,0,-13,6,-13,16","w":170},"\u00c6":{"d":"114,-212v-12,43,-30,79,-47,116r47,0r0,-116xm114,-72r-59,0r-32,72r-29,0r120,-252r113,0r0,25r-86,0r0,85r79,0r0,25r-79,0r0,92r87,0r0,25r-114,0r0,-72","w":245},"\u00c7":{"d":"44,-126v-5,75,43,129,104,94r7,22v-10,8,-26,13,-43,14r-5,11v16,4,24,13,24,27v0,23,-25,39,-51,31r2,-14v15,1,24,0,25,-13v0,-7,-8,-12,-25,-14r12,-28v-60,-8,-77,-60,-79,-130v-3,-90,48,-153,137,-122r-7,25v-10,-6,-23,-8,-39,-8v-51,0,-59,50,-62,105","w":164,"k":{" ":12,"\u00a0":12,"-":22,"\u00ad":22,"\u2013":22,"\u2014":22,"C":8,"G":8,"O":8,"Q":8,"\u00c7":8,"\u00d2":8,"\u00d3":8,"\u00d4":8,"\u00d5":8,"\u00d6":8,"\u00d8":8,"T":9,"V":10,"W":3,"X":13,"Y":11,"\u00dd":11,"Z":8,"c":10,"e":10,"g":10,"o":10,"q":10,"\u00e7":10,"\u00e8":10,"\u00e9":10,"\u00ea":10,"\u00eb":10,"\u00f0":10,"\u00f2":10,"\u00f3":10,"\u00f4":10,"\u00f5":10,"\u00f6":10,"\u00f8":10,"t":10,"v":13,"y":13,"\u00fd":13,"\u00ff":13,"w":12,"x":9,"z":6,"\u00c6":33,"A":9,"\u00c0":9,"\u00c1":9,"\u00c2":9,"\u00c3":9,"\u00c4":9,"\u00c5":9,"a":5,"m":5,"n":5,"p":5,"r":5,"s":5,"u":5,"\u00e6":5}},"\u00c8":{"d":"96,-271r-23,0r-46,-35r0,-7r36,0xm23,-252r112,0r0,25r-85,0r0,85r78,0r0,25r-78,0r0,92r87,0r0,25r-114,0r0,-252","w":154},"\u00c9":{"d":"93,-313r36,0r0,7r-48,35r-22,0xm23,-252r112,0r0,25r-85,0r0,85r78,0r0,25r-78,0r0,92r87,0r0,25r-114,0r0,-252","w":154},"\u00ca":{"d":"69,-313r18,0r37,37r0,7r-24,0v-8,-9,-18,-16,-22,-30v-5,13,-15,21,-24,30r-23,0r0,-8xm23,-252r112,0r0,25r-85,0r0,85r78,0r0,25r-78,0r0,92r87,0r0,25r-114,0r0,-252","w":154},"\u00cb":{"d":"49,-269v-10,0,-17,-7,-17,-17v0,-10,7,-17,17,-17v10,0,17,7,17,17v0,10,-7,17,-17,17xm106,-269v-10,0,-17,-7,-17,-17v0,-10,7,-17,17,-17v10,0,17,7,17,17v0,10,-7,17,-17,17xm23,-252r112,0r0,25r-85,0r0,85r78,0r0,25r-78,0r0,92r87,0r0,25r-114,0r0,-252","w":154},"\u00cc":{"d":"58,-271r-24,0r-46,-35r0,-7r36,0xm28,-252r27,0r0,252r-27,0r0,-252","w":83},"\u00cd":{"d":"61,-313r35,0r0,7r-47,35r-22,0xm28,-252r27,0r0,252r-27,0r0,-252","w":83},"\u00ce":{"d":"34,-313r18,0r37,37r0,7r-24,0v-8,-9,-18,-17,-23,-30v-8,18,-18,34,-47,30r0,-8xm28,-252r27,0r0,252r-27,0r0,-252","w":83},"\u00cf":{"d":"14,-269v-10,0,-17,-7,-17,-17v0,-10,7,-17,17,-17v10,0,17,7,17,17v0,10,-7,17,-17,17xm71,-269v-10,0,-17,-6,-17,-17v0,-11,7,-17,17,-17v10,0,16,7,16,17v0,10,-6,17,-16,17xm28,-252r27,0r0,252r-27,0r0,-252","w":83},"\u00d0":{"d":"176,-128v2,94,-48,147,-151,128r0,-120r-25,0r0,-21r25,0r0,-111v16,-3,35,-2,55,-3v73,1,94,53,96,127xm147,-128v0,-65,-24,-115,-95,-100r0,87r42,0r0,21r-42,0r0,97v74,12,95,-38,95,-105","w":191,"k":{"J":2,",":9,".":9,"\u2026":9,"T":13,"V":8,"W":6,"X":14,"Y":12,"\u00dd":12,"Z":7,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"x":9,"z":6,"\u00c6":15,"\"":12,"'":12,"\u2018":12,"\u2019":12,"\u201c":12,"\u201d":12,"A":6,"\u00c0":6,"\u00c1":6,"\u00c2":6,"\u00c3":6,"\u00c4":6,"\u00c5":6}},"\u00d1":{"d":"83,-302v20,0,40,21,55,4r10,13v-16,26,-46,15,-70,6v-9,2,-14,4,-21,11r-8,-13v10,-12,17,-21,34,-21xm154,4v-36,-68,-79,-129,-108,-203v4,57,3,133,3,199r-26,0r0,-256r16,0v36,67,79,127,108,201r2,0v-8,-59,-3,-131,-4,-197r26,0r0,256r-17,0","w":193},"\u00d2":{"d":"120,-271r-24,0r-45,-35r0,-7r35,0xm99,4v-69,0,-84,-60,-84,-130v0,-75,19,-130,84,-130v68,0,83,60,83,130v0,74,-19,130,-83,130xm99,-231v-47,0,-55,47,-55,105v0,50,7,105,55,105v47,0,55,-47,55,-105v0,-50,-7,-105,-55,-105","w":197,"k":{"J":2,",":9,".":9,"\u2026":9,"T":13,"V":8,"W":6,"X":14,"Y":12,"\u00dd":12,"Z":7,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"x":9,"z":6,"\u00c6":15,"\"":12,"'":12,"\u2018":12,"\u2019":12,"\u201c":12,"\u201d":12,"A":6,"\u00c0":6,"\u00c1":6,"\u00c2":6,"\u00c3":6,"\u00c4":6,"\u00c5":6}},"\u00d3":{"d":"121,-313r35,0r0,7r-47,35r-22,0xm99,4v-69,0,-84,-60,-84,-130v0,-75,19,-130,84,-130v68,0,83,60,83,130v0,74,-19,130,-83,130xm99,-231v-47,0,-55,47,-55,105v0,50,7,105,55,105v47,0,55,-47,55,-105v0,-50,-7,-105,-55,-105","w":197,"k":{"J":2,",":9,".":9,"\u2026":9,"T":13,"V":8,"W":6,"X":14,"Y":12,"\u00dd":12,"Z":7,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"x":9,"z":6,"\u00c6":15,"\"":12,"'":12,"\u2018":12,"\u2019":12,"\u201c":12,"\u201d":12,"A":6,"\u00c0":6,"\u00c1":6,"\u00c2":6,"\u00c3":6,"\u00c4":6,"\u00c5":6}},"\u00d4":{"d":"90,-313r18,0r37,37r0,7r-24,0v-8,-9,-18,-16,-22,-30v-5,13,-15,21,-24,30r-24,0r0,-8xm99,4v-69,0,-84,-60,-84,-130v0,-75,19,-130,84,-130v68,0,83,60,83,130v0,74,-19,130,-83,130xm99,-231v-47,0,-55,47,-55,105v0,50,7,105,55,105v47,0,55,-47,55,-105v0,-50,-7,-105,-55,-105","w":197,"k":{"J":2,",":9,".":9,"\u2026":9,"T":13,"V":8,"W":6,"X":14,"Y":12,"\u00dd":12,"Z":7,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"x":9,"z":6,"\u00c6":15,"\"":12,"'":12,"\u2018":12,"\u2019":12,"\u201c":12,"\u201d":12,"A":6,"\u00c0":6,"\u00c1":6,"\u00c2":6,"\u00c3":6,"\u00c4":6,"\u00c5":6}},"\u00d5":{"d":"85,-302v20,0,40,21,55,4r9,13v-20,40,-68,-12,-90,17r-9,-13v11,-12,18,-21,35,-21xm99,4v-69,0,-84,-60,-84,-130v0,-75,19,-130,84,-130v68,0,83,60,83,130v0,74,-19,130,-83,130xm99,-231v-47,0,-55,47,-55,105v0,50,7,105,55,105v47,0,55,-47,55,-105v0,-50,-7,-105,-55,-105","w":197,"k":{"J":2,",":9,".":9,"\u2026":9,"T":13,"V":8,"W":6,"X":14,"Y":12,"\u00dd":12,"Z":7,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"x":9,"z":6,"\u00c6":15,"\"":12,"'":12,"\u2018":12,"\u2019":12,"\u201c":12,"\u201d":12,"A":6,"\u00c0":6,"\u00c1":6,"\u00c2":6,"\u00c3":6,"\u00c4":6,"\u00c5":6}},"\u00d6":{"d":"70,-269v-10,0,-17,-7,-17,-17v0,-10,7,-17,17,-17v10,0,17,7,17,17v0,10,-7,17,-17,17xm127,-269v-10,0,-17,-7,-17,-17v0,-10,7,-17,17,-17v10,0,17,7,17,17v0,10,-7,17,-17,17xm99,4v-69,0,-84,-60,-84,-130v0,-75,19,-130,84,-130v68,0,83,60,83,130v0,74,-19,130,-83,130xm99,-231v-47,0,-55,47,-55,105v0,50,7,105,55,105v47,0,55,-47,55,-105v0,-50,-7,-105,-55,-105","w":197,"k":{"J":2,",":9,".":9,"\u2026":9,"T":13,"V":8,"W":6,"X":14,"Y":12,"\u00dd":12,"Z":7,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"x":9,"z":6,"\u00c6":15,"\"":12,"'":12,"\u2018":12,"\u2019":12,"\u201c":12,"\u201d":12,"A":6,"\u00c0":6,"\u00c1":6,"\u00c2":6,"\u00c3":6,"\u00c4":6,"\u00c5":6}},"\u00d7":{"d":"37,-185r38,44r38,-44r17,17r-39,46r39,47r-17,16r-38,-44r-38,44r-18,-16r40,-47r-40,-46","w":149},"\u00d8":{"d":"35,-31v-35,-69,-32,-231,64,-225v22,1,40,7,51,18r11,-19r17,10r-15,26v35,68,31,225,-64,225v-21,0,-38,-6,-51,-18r-9,18r-18,-10xm99,-231v-64,0,-61,109,-47,168r83,-148v-7,-11,-18,-21,-36,-20xm99,-21v64,1,62,-110,46,-167r-82,148v7,11,19,19,36,19","w":197,"k":{"J":2,",":9,".":9,"\u2026":9,"T":13,"V":8,"W":6,"X":14,"Y":12,"\u00dd":12,"Z":7,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"x":9,"z":6,"\u00c6":15,"\"":12,"'":12,"\u2018":12,"\u2019":12,"\u201c":12,"\u201d":12,"A":6,"\u00c0":6,"\u00c1":6,"\u00c2":6,"\u00c3":6,"\u00c4":6,"\u00c5":6}},"\u00d9":{"d":"117,-271r-23,0r-46,-35r0,-7r36,0xm96,-22v38,-1,43,-28,43,-69r0,-161r26,0r0,169v0,54,-19,86,-69,86v-51,-1,-74,-26,-73,-80r0,-175r27,0r0,161v1,39,6,70,46,69","w":187},"\u00da":{"d":"112,-313r36,0r0,7r-48,35r-22,0xm96,-22v38,-1,43,-28,43,-69r0,-161r26,0r0,169v0,54,-19,86,-69,86v-51,-1,-74,-26,-73,-80r0,-175r27,0r0,161v1,39,6,70,46,69","w":187},"\u00db":{"d":"86,-313r18,0r37,37r0,7r-24,0v-8,-9,-18,-16,-22,-30v-8,18,-18,34,-47,30r0,-8xm96,-22v38,-1,43,-28,43,-69r0,-161r26,0r0,169v0,54,-19,86,-69,86v-51,-1,-74,-26,-73,-80r0,-175r27,0r0,161v1,39,6,70,46,69","w":187},"\u00dc":{"d":"66,-269v-10,0,-17,-6,-17,-17v0,-11,7,-17,17,-17v10,0,16,7,16,17v0,10,-6,17,-16,17xm122,-269v-10,0,-16,-7,-16,-17v0,-10,6,-17,16,-17v10,0,17,6,17,17v0,11,-7,17,-17,17xm96,-22v38,-1,43,-28,43,-69r0,-161r26,0r0,169v0,54,-19,86,-69,86v-51,-1,-74,-26,-73,-80r0,-175r27,0r0,161v1,39,6,70,46,69","w":187},"\u00dd":{"d":"102,-313r35,0r0,7r-47,35r-22,0xm69,-100r-67,-152r31,0v17,44,39,83,51,132v11,-50,33,-87,49,-132r29,0r-66,152r0,100r-27,0r0,-100","w":163,"k":{"\u00ff":14,"\u00f6":26,"\u00f5":26,"\u00f2":26,"\u00ef":18,"\u00ee":18,"\u00ec":18,"\u00eb":26,"\u00e8":26,"\u00e5":18,"\u00e2":18,"\u00e1":18," ":7,"\u00a0":7,"*":-7,"-":18,"\u00ad":18,"\u2013":18,"\u2014":18,",":32,".":32,"\u2026":32,"C":12,"G":12,"O":12,"Q":12,"\u00c7":12,"\u00d2":12,"\u00d3":12,"\u00d4":12,"\u00d5":12,"\u00d6":12,"\u00d8":12,"T":6,"V":4,"W":3,"X":9,"Y":4,"\u00dd":4,"Z":9,"c":26,"e":26,"g":26,"o":26,"q":26,"\u00e7":26,"\u00e9":26,"\u00ea":26,"\u00f0":26,"\u00f3":26,"\u00f4":26,"\u00f8":26,"t":12,"v":14,"y":14,"\u00fd":14,"w":12,"x":17,"z":19,"\u00c6":29,"\"":-10,"'":-10,"\u2018":-10,"\u2019":-10,"\u201c":-10,"\u201d":-10,"\u00ae":-2,"\u2122":-2,"A":21,"\u00c0":21,"\u00c1":21,"\u00c2":21,"\u00c3":21,"\u00c4":21,"\u00c5":21,"a":21,"m":21,"n":21,"p":21,"r":21,"s":21,"u":21,"\u00e6":21,"\u00e0":18,"\u00e3":18,"\u00e4":18,"\u00ed":18,"\u00f1":18,"\u00f9":18,"\u00fa":18,"\u00fb":18,"\u00fc":18}},"\u00de":{"d":"152,-177v0,61,-41,91,-102,81r0,96r-27,0r0,-288r27,0r0,34v62,-7,102,15,102,77xm124,-177v0,-44,-31,-60,-74,-51r0,107v44,8,74,-11,74,-56","w":162,"k":{" ":12,"\u00a0":12,",":38,".":38,"\u2026":38,"C":5,"G":5,"O":5,"Q":5,"\u00c7":5,"\u00d2":5,"\u00d3":5,"\u00d4":5,"\u00d5":5,"\u00d6":5,"\u00d8":5,"T":4,"X":13,"Y":7,"\u00dd":7,"Z":8,"c":10,"e":10,"g":10,"o":10,"q":10,"\u00e7":10,"\u00e8":10,"\u00e9":10,"\u00ea":10,"\u00eb":10,"\u00f0":10,"\u00f2":10,"\u00f3":10,"\u00f4":10,"\u00f5":10,"\u00f6":10,"\u00f8":10,"x":10,"z":7,"\u00c6":33,"A":19,"\u00c0":19,"\u00c1":19,"\u00c2":19,"\u00c3":19,"\u00c4":19,"\u00c5":19,"a":10,"m":10,"n":10,"p":10,"r":10,"s":10,"u":10,"\u00e6":10}},"\u00df":{"d":"97,-226v-32,-16,-43,7,-43,46r0,180r-26,0r0,-157r-22,0r0,-23r22,0v-7,-59,23,-89,75,-68xm176,-45v0,51,-64,59,-100,38r8,-23v17,13,68,20,66,-14v-4,-50,-69,-38,-69,-94v0,-48,57,-57,92,-36r-7,21v-16,-9,-64,-17,-59,14v7,45,69,37,69,94","w":187},"\u00e0":{"d":"98,-122v8,-48,-45,-40,-70,-27r-9,-20v36,-22,115,-22,104,41v2,43,-5,91,3,129r-20,0v-3,-7,-3,-17,-7,-22v-17,38,-93,28,-89,-27v3,-46,37,-57,87,-55v1,-7,1,-13,1,-19xm37,-51v0,41,61,35,61,7r0,-38v-29,-2,-61,1,-61,31xm88,-206r-15,0v-10,-19,-28,-29,-33,-53r29,0","w":144},"\u00e1":{"d":"98,-122v8,-48,-45,-40,-70,-27r-9,-20v36,-22,115,-22,104,41v2,43,-5,91,3,129r-20,0v-3,-7,-3,-17,-7,-22v-17,38,-93,28,-89,-27v3,-46,37,-57,87,-55v1,-7,1,-13,1,-19xm37,-51v0,41,61,35,61,7r0,-38v-29,-2,-61,1,-61,31xm70,-259r28,0v-4,24,-21,34,-30,53r-15,0","w":144},"\u00e2":{"d":"68,-264r13,0r32,66r-23,0v-7,-14,-13,-28,-17,-45v-4,18,-11,31,-19,45r-21,0xm98,-122v8,-48,-45,-40,-70,-27r-9,-20v36,-22,115,-22,104,41v2,43,-5,91,3,129r-20,0v-3,-7,-3,-17,-7,-22v-17,38,-93,28,-89,-27v3,-46,37,-57,87,-55v1,-7,1,-13,1,-19xm37,-51v0,41,61,35,61,7r0,-38v-29,-2,-61,1,-61,31","w":144},"\u00e3":{"d":"88,-219v-18,-1,-37,-24,-51,-3r-8,-13v14,-27,42,-21,65,-8v6,-1,9,-3,14,-8r8,14v-10,10,-13,18,-28,18xm98,-122v8,-48,-45,-40,-70,-27r-9,-20v36,-22,115,-22,104,41v2,43,-5,91,3,129r-20,0v-3,-7,-3,-17,-7,-22v-17,38,-93,28,-89,-27v3,-46,37,-57,87,-55v1,-7,1,-13,1,-19xm37,-51v0,41,61,35,61,7r0,-38v-29,-2,-61,1,-61,31","w":144},"\u00e4":{"d":"98,-122v8,-48,-45,-40,-70,-27r-9,-20v36,-22,115,-22,104,41v2,43,-5,91,3,129r-20,0v-3,-7,-3,-17,-7,-22v-17,38,-93,28,-89,-27v3,-46,37,-57,87,-55v1,-7,1,-13,1,-19xm37,-51v0,41,61,35,61,7r0,-38v-29,-2,-61,1,-61,31xm43,-218v-9,0,-15,-7,-15,-17v0,-11,5,-18,15,-18v10,0,16,7,16,18v0,9,-7,17,-16,17xm100,-218v-9,0,-15,-7,-15,-17v0,-11,5,-18,15,-18v10,0,17,7,16,18v0,10,-6,17,-16,17","w":144},"\u00e5":{"d":"72,-200v-19,0,-30,-11,-30,-31v0,-19,11,-33,30,-33v19,1,30,12,30,33v0,19,-11,32,-30,31xm72,-248v-8,0,-13,7,-12,17v0,10,4,16,12,16v9,0,12,-6,13,-16v1,-10,-5,-17,-13,-17xm98,-122v8,-48,-45,-40,-70,-27r-9,-20v36,-22,115,-22,104,41v2,43,-5,91,3,129r-20,0v-3,-7,-3,-17,-7,-22v-17,38,-93,28,-89,-27v3,-46,37,-57,87,-55v1,-7,1,-13,1,-19xm37,-51v0,41,61,35,61,7r0,-38v-29,-2,-61,1,-61,31","w":144},"\u00e6":{"d":"37,-52v-1,15,10,32,25,31v33,0,39,-26,36,-62v-29,-3,-60,1,-61,31xm212,-12v-27,26,-92,19,-106,-14v-17,41,-99,38,-96,-23v3,-46,40,-58,87,-54v2,-29,4,-59,-27,-57v-15,1,-33,6,-43,13r-8,-20v22,-18,86,-27,97,7v7,-15,25,-24,45,-24v52,0,59,45,54,98r-92,0v2,39,8,66,45,67v13,0,27,-6,34,-12xm191,-108v7,-45,-32,-70,-56,-40v-7,8,-11,22,-12,40r68,0","w":231},"\u00e7":{"d":"82,-20v12,0,24,-4,31,-10r8,21v-11,11,-36,6,-39,24v16,4,23,13,23,27v1,24,-25,39,-51,31r3,-14v15,1,23,-1,24,-13v0,-7,-8,-12,-25,-14r13,-28v-44,-5,-54,-45,-56,-94v-3,-71,43,-114,105,-85r-7,22v-42,-23,-75,8,-71,63v3,36,7,68,42,70","w":128,"k":{"y":4," ":7,"\u00a0":7,"-":13,"\u00ad":13,"\u2013":13,"\u2014":13,"c":6,"e":6,"g":6,"o":6,"q":6,"\u00e7":6,"\u00e8":6,"\u00e9":6,"\u00ea":6,"\u00eb":6,"\u00f0":6,"\u00f2":6,"\u00f3":6,"\u00f4":6,"\u00f5":6,"\u00f6":6,"\u00f8":6,"x":4,"z":4,"\"":2,"'":2,"\u2018":2,"\u2019":2,"\u201c":2,"\u201d":2}},"\u00e8":{"d":"86,-19v12,-1,27,-6,34,-12r9,19v-11,10,-30,16,-50,16v-51,-1,-66,-42,-66,-94v0,-54,17,-92,65,-94v52,-3,60,45,54,97r-92,0v1,37,10,67,46,68xm109,-109v7,-44,-33,-67,-57,-39v-6,8,-10,21,-11,39r68,0xm94,-206r-15,0v-10,-19,-28,-29,-33,-53r29,0","w":148,"k":{"*":2,"c":3,"e":3,"g":3,"o":3,"q":3,"\u00e7":3,"\u00e8":3,"\u00e9":3,"\u00ea":3,"\u00eb":3,"\u00f0":3,"\u00f2":3,"\u00f3":3,"\u00f4":3,"\u00f5":3,"\u00f6":3,"\u00f8":3,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"w":3,"x":6,"z":3,"\"":5,"'":5,"\u2018":5,"\u2019":5,"\u201c":5,"\u201d":5,"\u00ae":2,"\u2122":2}},"\u00e9":{"d":"86,-19v12,-1,27,-6,34,-12r9,19v-11,10,-30,16,-50,16v-51,-1,-66,-42,-66,-94v0,-54,17,-92,65,-94v52,-3,60,45,54,97r-92,0v1,37,10,67,46,68xm109,-109v7,-44,-33,-67,-57,-39v-6,8,-10,21,-11,39r68,0xm84,-259r28,0v-4,24,-21,34,-30,53r-15,0","w":148,"k":{"*":2,"c":3,"e":3,"g":3,"o":3,"q":3,"\u00e7":3,"\u00e8":3,"\u00e9":3,"\u00ea":3,"\u00eb":3,"\u00f0":3,"\u00f2":3,"\u00f3":3,"\u00f4":3,"\u00f5":3,"\u00f6":3,"\u00f8":3,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"w":3,"x":6,"z":3,"\"":5,"'":5,"\u2018":5,"\u2019":5,"\u201c":5,"\u201d":5,"\u00ae":2,"\u2122":2}},"\u00ea":{"d":"71,-264r13,0r32,66r-23,0v-7,-14,-14,-27,-17,-45v-5,17,-12,31,-19,45r-22,0xm86,-19v12,-1,27,-6,34,-12r9,19v-11,10,-30,16,-50,16v-51,-1,-66,-42,-66,-94v0,-54,17,-92,65,-94v52,-3,60,45,54,97r-92,0v1,37,10,67,46,68xm109,-109v7,-44,-33,-67,-57,-39v-6,8,-10,21,-11,39r68,0","w":148,"k":{"*":2,"c":3,"e":3,"g":3,"o":3,"q":3,"\u00e7":3,"\u00e8":3,"\u00e9":3,"\u00ea":3,"\u00eb":3,"\u00f0":3,"\u00f2":3,"\u00f3":3,"\u00f4":3,"\u00f5":3,"\u00f6":3,"\u00f8":3,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"w":3,"x":6,"z":3,"\"":5,"'":5,"\u2018":5,"\u2019":5,"\u201c":5,"\u201d":5,"\u00ae":2,"\u2122":2}},"\u00eb":{"d":"86,-19v12,-1,27,-6,34,-12r9,19v-11,10,-30,16,-50,16v-51,-1,-66,-42,-66,-94v0,-54,17,-92,65,-94v52,-3,60,45,54,97r-92,0v1,37,10,67,46,68xm109,-109v7,-44,-33,-67,-57,-39v-6,8,-10,21,-11,39r68,0xm49,-218v-9,0,-15,-7,-15,-17v0,-11,5,-18,15,-18v10,0,16,7,16,18v0,9,-7,17,-16,17xm106,-218v-9,0,-15,-7,-15,-17v0,-11,5,-18,15,-18v10,0,17,7,16,18v0,10,-6,17,-16,17","w":148,"k":{"*":2,"c":3,"e":3,"g":3,"o":3,"q":3,"\u00e7":3,"\u00e8":3,"\u00e9":3,"\u00ea":3,"\u00eb":3,"\u00f0":3,"\u00f2":3,"\u00f3":3,"\u00f4":3,"\u00f5":3,"\u00f6":3,"\u00f8":3,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"w":3,"x":6,"z":3,"\"":5,"'":5,"\u2018":5,"\u2019":5,"\u201c":5,"\u201d":5,"\u00ae":2,"\u2122":2}},"\u00ec":{"d":"26,-180r26,0r0,180r-26,0r0,-180xm50,-206r-15,0v-10,-19,-28,-29,-33,-53r29,0","w":78},"\u00ed":{"d":"26,-180r26,0r0,180r-26,0r0,-180xm45,-259r28,0v-4,24,-21,34,-30,53r-15,0","w":78},"\u00ee":{"d":"34,-264r12,0r32,66r-22,0v-7,-14,-14,-27,-17,-45v-5,17,-12,31,-20,45r-21,0xm26,-180r26,0r0,180r-26,0r0,-180","w":78},"\u00ef":{"d":"26,-180r26,0r0,180r-26,0r0,-180xm10,-218v-9,0,-15,-7,-15,-17v0,-11,5,-18,15,-18v10,0,16,7,16,18v0,9,-7,17,-16,17xm67,-218v-9,0,-15,-7,-15,-17v0,-11,5,-18,15,-18v10,0,17,7,16,18v0,10,-6,17,-16,17","w":78,"k":{"\u2122":-9,"\u00ae":-9}},"\u00f0":{"d":"15,-90v-5,-67,51,-121,103,-78v-5,-24,-15,-45,-33,-56r-12,26r-15,-7r12,-26v-9,-3,-19,-4,-30,-4r0,-21v15,0,27,1,39,5r9,-20r15,7r-9,19v40,24,54,72,53,138v-1,60,-10,111,-66,111v-52,0,-62,-42,-66,-94xm83,-160v-35,1,-41,34,-41,70v-1,41,10,68,40,71v45,-5,40,-76,37,-122v-5,-11,-21,-19,-36,-19","w":162},"\u00f1":{"d":"95,-219v-18,-1,-37,-24,-50,-3r-9,-13v14,-27,42,-21,65,-8v6,-1,9,-3,14,-8r8,14v-10,10,-13,18,-28,18xm92,-184v75,1,39,116,47,184r-26,0r0,-110v-1,-30,-2,-50,-28,-51v-21,0,-32,15,-38,30r0,131r-26,0r0,-180r19,0v2,6,2,15,6,19v9,-12,24,-24,46,-23","w":158},"\u00f2":{"d":"78,4v-51,0,-65,-38,-65,-94v0,-56,16,-94,65,-94v51,0,64,38,64,94v0,57,-16,94,-64,94xm78,-161v-32,0,-38,31,-38,71v0,36,4,71,38,71v32,0,37,-30,37,-71v0,-35,-4,-71,-37,-71xm91,-206r-15,0v-10,-19,-28,-29,-33,-53r29,0","w":155,"k":{"f":4,"*":2,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":3,"x":7,"z":4,"\"":17,"'":17,"\u2018":17,"\u2019":17,"\u201c":17,"\u201d":17}},"\u00f3":{"d":"78,4v-51,0,-65,-38,-65,-94v0,-56,16,-94,65,-94v51,0,64,38,64,94v0,57,-16,94,-64,94xm78,-161v-32,0,-38,31,-38,71v0,36,4,71,38,71v32,0,37,-30,37,-71v0,-35,-4,-71,-37,-71xm82,-259r28,0v-4,24,-21,34,-30,53r-15,0","w":155,"k":{"f":4,"*":2,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":3,"x":7,"z":4,"\"":17,"'":17,"\u2018":17,"\u2019":17,"\u201c":17,"\u201d":17}},"\u00f4":{"d":"74,-264r13,0r32,66r-23,0v-7,-14,-13,-28,-17,-45v-4,18,-11,31,-19,45r-21,0xm78,4v-51,0,-65,-38,-65,-94v0,-56,16,-94,65,-94v51,0,64,38,64,94v0,57,-16,94,-64,94xm78,-161v-32,0,-38,31,-38,71v0,36,4,71,38,71v32,0,37,-30,37,-71v0,-35,-4,-71,-37,-71","w":155,"k":{"f":4,"*":2,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":3,"x":7,"z":4,"\"":17,"'":17,"\u2018":17,"\u2019":17,"\u201c":17,"\u201d":17}},"\u00f5":{"d":"94,-219v-18,-1,-37,-24,-51,-3r-8,-13v14,-27,41,-21,64,-8v7,-1,9,-3,14,-8r9,14v-10,10,-14,18,-28,18xm78,4v-51,0,-65,-38,-65,-94v0,-56,16,-94,65,-94v51,0,64,38,64,94v0,57,-16,94,-64,94xm78,-161v-32,0,-38,31,-38,71v0,36,4,71,38,71v32,0,37,-30,37,-71v0,-35,-4,-71,-37,-71","w":155,"k":{"f":4,"*":2,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":3,"x":7,"z":4,"\"":17,"'":17,"\u2018":17,"\u2019":17,"\u201c":17,"\u201d":17}},"\u00f6":{"d":"78,4v-51,0,-65,-38,-65,-94v0,-56,16,-94,65,-94v51,0,64,38,64,94v0,57,-16,94,-64,94xm78,-161v-32,0,-38,31,-38,71v0,36,4,71,38,71v32,0,37,-30,37,-71v0,-35,-4,-71,-37,-71xm49,-218v-9,0,-15,-7,-15,-17v0,-11,5,-18,15,-18v10,0,16,7,16,18v0,9,-7,17,-16,17xm106,-218v-9,0,-15,-7,-15,-17v0,-11,5,-18,15,-18v10,0,17,7,16,18v0,10,-6,17,-16,17","w":155,"k":{"f":4,"*":2,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":3,"x":7,"z":4,"\"":17,"'":17,"\u2018":17,"\u2019":17,"\u201c":17,"\u201d":17}},"\u00f7":{"d":"13,-134r123,0r0,24r-123,0r0,-24xm75,-163v-13,0,-18,-8,-18,-21v0,-13,6,-20,18,-20v12,0,18,7,18,20v0,13,-5,21,-18,21xm75,-41v-12,0,-18,-7,-18,-20v0,-13,6,-20,18,-20v12,0,18,7,18,20v0,13,-6,20,-18,20","w":149},"\u00f8":{"d":"129,-157v27,51,22,161,-50,161v-15,0,-27,-3,-37,-11r-8,12r-17,-11r10,-19v-25,-50,-19,-159,52,-159v14,0,25,3,35,10r7,-11r18,10xm54,-31v33,31,62,-6,62,-59v0,-15,-1,-28,-4,-40xm102,-150v-32,-29,-67,9,-61,60v2,15,1,27,4,39","w":156,"k":{"f":4,"*":2,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":3,"x":7,"z":4,"\"":17,"'":17,"\u2018":17,"\u2019":17,"\u201c":17,"\u201d":17}},"\u00f9":{"d":"66,4v-75,-1,-38,-116,-47,-184r26,0r0,110v0,30,1,51,26,51v60,0,32,-101,38,-161r26,0r0,129v0,17,2,36,3,51r-18,0v-3,-8,-3,-19,-8,-25v-7,15,-22,29,-46,29xm89,-206r-15,0v-10,-19,-28,-29,-33,-53r29,0","w":156},"\u00fa":{"d":"66,4v-75,-1,-38,-116,-47,-184r26,0r0,110v0,30,1,51,26,51v60,0,32,-101,38,-161r26,0r0,129v0,17,2,36,3,51r-18,0v-3,-8,-3,-19,-8,-25v-7,15,-22,29,-46,29xm82,-259r28,0v-4,24,-21,34,-30,53r-15,0","w":156},"\u00fb":{"d":"73,-264r13,0r32,66r-23,0v-7,-14,-13,-28,-17,-45v-4,18,-11,31,-19,45r-22,0xm66,4v-75,-1,-38,-116,-47,-184r26,0r0,110v0,30,1,51,26,51v60,0,32,-101,38,-161r26,0r0,129v0,17,2,36,3,51r-18,0v-3,-8,-3,-19,-8,-25v-7,15,-22,29,-46,29","w":156},"\u00fc":{"d":"66,4v-75,-1,-38,-116,-47,-184r26,0r0,110v0,30,1,51,26,51v60,0,32,-101,38,-161r26,0r0,129v0,17,2,36,3,51r-18,0v-3,-8,-3,-19,-8,-25v-7,15,-22,29,-46,29xm48,-218v-9,0,-15,-7,-15,-17v0,-11,5,-18,15,-18v10,0,16,7,16,18v0,9,-7,17,-16,17xm105,-218v-9,0,-15,-7,-15,-17v0,-11,5,-18,15,-18v10,0,17,7,16,18v0,10,-6,17,-16,17","w":156},"\u00fd":{"d":"75,-29v8,-53,22,-101,33,-151r26,0r-53,198v-9,29,-20,66,-59,53r4,-25v25,6,30,-22,35,-46r-58,-180r29,0xm79,-259r28,0v-4,24,-21,34,-30,53r-15,0","w":135,"k":{" ":10,"\u00a0":10,"*":-2,",":21,".":21,"\u2026":21,"v":-4,"y":-4,"\u00fd":-4,"\u00ff":-4,"w":-3,"x":3,"z":2}},"\u00fe":{"d":"143,-94v3,65,-37,115,-96,92r0,74r-26,0r0,-324r26,0r1,86v9,-11,20,-18,39,-18v46,0,53,36,56,90xm116,-94v-3,-33,-4,-67,-35,-67v-52,0,-29,83,-34,133v37,28,74,-14,69,-66","w":156,"k":{"f":4,"*":2,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":3,"x":7,"z":4,"\"":17,"'":17,"\u2018":17,"\u2019":17,"\u201c":17,"\u201d":17}},"\u00ff":{"d":"75,-29v8,-53,22,-101,33,-151r26,0r-53,198v-9,29,-20,66,-59,53r4,-25v25,6,30,-22,35,-46r-58,-180r29,0xm39,-218v-9,0,-15,-7,-15,-17v0,-11,5,-18,15,-18v10,0,16,7,16,18v0,9,-7,17,-16,17xm96,-218v-9,0,-15,-7,-15,-17v0,-11,5,-18,15,-18v10,0,17,7,16,18v0,10,-6,17,-16,17","w":135,"k":{" ":10,"\u00a0":10,"*":-2,",":21,".":21,"\u2026":21,"v":-4,"y":-4,"\u00fd":-4,"\u00ff":-4,"w":-3,"x":3,"z":2}},"\u2013":{"d":"33,-116r124,0r0,25r-124,0r0,-25","w":190,"k":{" ":23,"\u00a0":23,"*":4,"-":5,"\u00ad":5,"\u2013":5,"\u2014":5,",":36,".":36,"\u2026":36,"T":6,"V":3,"W":2,"X":4,"Y":4,"\u00dd":4,"\u00c6":4,"\"":39,"'":39,"\u2018":39,"\u2019":39,"\u201c":39,"\u201d":39,"A":2,"\u00c0":2,"\u00c1":2,"\u00c2":2,"\u00c3":2,"\u00c4":2,"\u00c5":2,")":3,"]":3,"}":3}},"\u2014":{"d":"34,-116r170,0r0,25r-170,0r0,-25","w":238,"k":{" ":23,"\u00a0":23,"*":4,"-":5,"\u00ad":5,"\u2013":5,"\u2014":5,",":36,".":36,"\u2026":36,"T":6,"V":3,"W":2,"X":4,"Y":4,"\u00dd":4,"\u00c6":4,"\"":39,"'":39,"\u2018":39,"\u2019":39,"\u201c":39,"\u201d":39,"A":2,"\u00c0":2,"\u00c1":2,"\u00c2":2,"\u00c3":2,"\u00c4":2,"\u00c5":2,")":3,"]":3,"}":3}},"\u2018":{"d":"31,-205v-37,-5,-15,-71,7,-75r8,11v-7,6,-14,16,-14,29v10,-1,15,6,15,17v0,11,-6,17,-16,18","w":58,"k":{" ":24,"\u00a0":24,"-":46,"\u00ad":46,"\u2013":46,"\u2014":46,",":36,".":36,"\u2026":36,"C":12,"G":12,"O":12,"Q":12,"\u00c7":12,"\u00d2":12,"\u00d3":12,"\u00d4":12,"\u00d5":12,"\u00d6":12,"\u00d8":12,"V":-12,"W":-12,"Y":-10,"\u00dd":-10,"c":30,"e":30,"g":30,"o":30,"q":30,"\u00e7":30,"\u00e8":30,"\u00e9":30,"\u00ea":30,"\u00eb":30,"\u00f0":30,"\u00f2":30,"\u00f3":30,"\u00f4":30,"\u00f5":30,"\u00f6":30,"\u00f8":30,"\u00c6":58,"A":36,"\u00c0":36,"\u00c1":36,"\u00c2":36,"\u00c3":36,"\u00c4":36,"\u00c5":36,"a":19,"m":19,"n":19,"p":19,"r":19,"s":19,"u":19,"\u00e6":19}},"\u2019":{"d":"28,-255v36,0,14,69,-7,74r-9,-11v8,-5,16,-15,15,-28v-9,1,-16,-7,-16,-17v0,-11,7,-18,17,-18","w":58,"k":{" ":24,"\u00a0":24,"-":46,"\u00ad":46,"\u2013":46,"\u2014":46,",":36,".":36,"\u2026":36,"C":12,"G":12,"O":12,"Q":12,"\u00c7":12,"\u00d2":12,"\u00d3":12,"\u00d4":12,"\u00d5":12,"\u00d6":12,"\u00d8":12,"V":-12,"W":-12,"Y":-10,"\u00dd":-10,"c":30,"e":30,"g":30,"o":30,"q":30,"\u00e7":30,"\u00e8":30,"\u00e9":30,"\u00ea":30,"\u00eb":30,"\u00f0":30,"\u00f2":30,"\u00f3":30,"\u00f4":30,"\u00f5":30,"\u00f6":30,"\u00f8":30,"\u00c6":58,"A":36,"\u00c0":36,"\u00c1":36,"\u00c2":36,"\u00c3":36,"\u00c4":36,"\u00c5":36,"a":19,"m":19,"n":19,"p":19,"r":19,"s":19,"u":19,"\u00e6":19}},"\u201c":{"d":"76,-205v-37,-5,-15,-71,7,-75r8,11v-7,6,-14,16,-14,29v10,-1,15,6,15,17v0,11,-6,17,-16,18xm31,-205v-37,-5,-15,-71,7,-75r8,11v-7,6,-14,16,-14,29v10,-1,15,6,15,17v0,11,-6,17,-16,18","w":103,"k":{" ":24,"\u00a0":24,"-":46,"\u00ad":46,"\u2013":46,"\u2014":46,",":36,".":36,"\u2026":36,"C":12,"G":12,"O":12,"Q":12,"\u00c7":12,"\u00d2":12,"\u00d3":12,"\u00d4":12,"\u00d5":12,"\u00d6":12,"\u00d8":12,"V":-12,"W":-12,"Y":-10,"\u00dd":-10,"c":30,"e":30,"g":30,"o":30,"q":30,"\u00e7":30,"\u00e8":30,"\u00e9":30,"\u00ea":30,"\u00eb":30,"\u00f0":30,"\u00f2":30,"\u00f3":30,"\u00f4":30,"\u00f5":30,"\u00f6":30,"\u00f8":30,"\u00c6":58,"A":36,"\u00c0":36,"\u00c1":36,"\u00c2":36,"\u00c3":36,"\u00c4":36,"\u00c5":36,"a":19,"m":19,"n":19,"p":19,"r":19,"s":19,"u":19,"\u00e6":19}},"\u201d":{"d":"73,-255v36,0,14,69,-7,74r-9,-11v8,-5,16,-15,15,-28v-9,1,-16,-7,-16,-17v0,-11,7,-18,17,-18xm28,-255v36,0,14,69,-7,74r-9,-11v8,-5,16,-15,15,-28v-9,1,-16,-7,-16,-17v0,-11,7,-18,17,-18","w":103,"k":{" ":24,"\u00a0":24,"-":46,"\u00ad":46,"\u2013":46,"\u2014":46,",":36,".":36,"\u2026":36,"C":12,"G":12,"O":12,"Q":12,"\u00c7":12,"\u00d2":12,"\u00d3":12,"\u00d4":12,"\u00d5":12,"\u00d6":12,"\u00d8":12,"V":-12,"W":-12,"Y":-10,"\u00dd":-10,"c":30,"e":30,"g":30,"o":30,"q":30,"\u00e7":30,"\u00e8":30,"\u00e9":30,"\u00ea":30,"\u00eb":30,"\u00f0":30,"\u00f2":30,"\u00f3":30,"\u00f4":30,"\u00f5":30,"\u00f6":30,"\u00f8":30,"\u00c6":58,"A":36,"\u00c0":36,"\u00c1":36,"\u00c2":36,"\u00c3":36,"\u00c4":36,"\u00c5":36,"a":19,"m":19,"n":19,"p":19,"r":19,"s":19,"u":19,"\u00e6":19}},"\u2026":{"d":"201,4v-12,0,-18,-7,-18,-20v0,-13,6,-20,18,-20v12,0,18,7,18,20v0,13,-6,20,-18,20xm120,4v-12,0,-18,-7,-18,-20v0,-13,6,-20,18,-20v12,0,18,7,18,20v0,13,-6,20,-18,20xm40,4v-12,0,-18,-7,-18,-20v0,-13,6,-20,18,-20v12,0,18,7,18,20v0,13,-6,20,-18,20","w":236,"k":{"J":-6," ":7,"\u00a0":7,"*":12,"-":36,"\u00ad":36,"\u2013":36,"\u2014":36,"T":5,"V":6,"W":4,"Y":6,"\u00dd":6,"v":2,"y":2,"\u00fd":2,"\u00ff":2,"\"":41,"'":41,"\u2018":41,"\u2019":41,"\u201c":41,"\u201d":41,"\u00ae":8,"\u2122":8}},"\u2122":{"d":"115,-229r-38,0r0,107r-26,0r0,-107r-38,0r0,-23r102,0r0,23xm229,-220v-10,29,-23,55,-36,81r-12,0v-13,-26,-24,-54,-36,-81v5,29,4,64,4,98r-23,0r0,-130r26,0r37,81r36,-81r26,0r0,130r-25,0v-1,-34,1,-71,3,-98","w":263}}});
